/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.channels.DetachableStreamSinkChannel;
import io.undertow.channels.DetachableStreamSourceChannel;
import io.undertow.io.AsyncSenderImpl;
import io.undertow.io.BlockingSenderImpl;
import io.undertow.io.Sender;
import io.undertow.io.UndertowInputStream;
import io.undertow.io.UndertowOutputStream;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.Connectors;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Cookies;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.NetworkUtils;
import io.undertow.util.Protocols;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.XnioIoThread;
import org.xnio.channels.Channels;
import org.xnio.channels.EmptyStreamSourceChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.Conduit;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class HttpServerExchange
extends AbstractAttachable {
    private static final Logger log = Logger.getLogger(HttpServerExchange.class);
    private final ServerConnection connection;
    private final HeaderMap requestHeaders = new HeaderMap();
    private final HeaderMap responseHeaders = new HeaderMap();
    private int exchangeCompletionListenersCount = 0;
    private ExchangeCompletionListener[] exchangeCompleteListeners = new ExchangeCompletionListener[2];
    private DefaultResponseListener[] defaultResponseListeners = new DefaultResponseListener[2];
    private Map<String, Deque<String>> queryParameters;
    private Map<String, Deque<String>> pathParameters;
    private Map<String, Cookie> requestCookies;
    private Map<String, Cookie> responseCookies;
    private WriteDispatchChannel responseChannel;
    private ReadDispatchChannel requestChannel;
    private BlockingHttpExchange blockingHttpExchange;
    private HttpString protocol;
    private int state = 200;
    private HttpString requestMethod;
    private String requestScheme;
    private String requestURI;
    private String requestPath;
    private String relativePath;
    private String resolvedPath = "";
    private String queryString = "";
    private int requestWrapperCount = 0;
    private ConduitWrapper<StreamSourceConduit>[] requestWrappers;
    private int responseWrapperCount = 0;
    private ConduitWrapper<StreamSinkConduit>[] responseWrappers = new ConduitWrapper[4];
    private Sender sender;
    private long maxEntitySize;
    private Runnable dispatchTask;
    private Executor dispatchExecutor;
    private static final int MASK_RESPONSE_CODE = Bits.intBitMask(0, 9);
    private static final int FLAG_RESPONSE_SENT = 1024;
    private static final int FLAG_RESPONSE_TERMINATED = 2048;
    private static final int FLAG_REQUEST_TERMINATED = 4096;
    private static final int FLAG_PERSISTENT = 16384;
    private static final int FLAG_DISPATCHED = 32768;
    private static final int FLAG_URI_CONTAINS_HOST = 65536;
    private static final int FLAG_IN_CALL = 131072;
    private InetSocketAddress sourceAddress;

    public HttpServerExchange(ServerConnection connection, long maxEntitySize) {
        this.connection = connection;
        this.maxEntitySize = maxEntitySize;
    }

    public HttpServerExchange(ServerConnection connection) {
        this.connection = connection;
        this.maxEntitySize = 0L;
    }

    public HttpString getProtocol() {
        return this.protocol;
    }

    public void setProtocol(HttpString protocol) {
        this.protocol = protocol;
    }

    public boolean isHttp09() {
        return this.protocol.equals(Protocols.HTTP_0_9);
    }

    public boolean isHttp10() {
        return this.protocol.equals(Protocols.HTTP_1_0);
    }

    public boolean isHttp11() {
        return this.protocol.equals(Protocols.HTTP_1_1);
    }

    public HttpString getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(HttpString requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getRequestScheme() {
        return this.requestScheme;
    }

    public void setRequestScheme(String requestScheme) {
        this.requestScheme = requestScheme;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public void setRequestURI(String requestURI, boolean containsHost) {
        this.requestURI = requestURI;
        this.state = containsHost ? (this.state |= 0x10000) : (this.state &= 0xFFFEFFFF);
    }

    public boolean isHostIncludedInRequestURI() {
        return Bits.anyAreSet(this.state, 65536);
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public void setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestURL() {
        if (this.isHostIncludedInRequestURI()) {
            return this.getRequestURI();
        }
        return this.getRequestScheme() + "://" + this.getHostAndPort() + this.getRequestURI();
    }

    public String getHostName() {
        String host = this.requestHeaders.getFirst(Headers.HOST);
        if (host == null) {
            host = this.getDestinationAddress().getAddress().getHostAddress();
        } else if (host.startsWith("[")) {
            host = host.substring(1, host.indexOf(93));
        } else if (host.indexOf(58) != -1) {
            host = host.substring(0, host.indexOf(58));
        }
        return host;
    }

    public String getHostAndPort() {
        String host = this.requestHeaders.getFirst(Headers.HOST);
        if (host == null) {
            host = NetworkUtils.formatPossibleIpv6Address(this.getDestinationAddress().getAddress().getHostAddress());
            int port = this.getDestinationAddress().getPort();
            if (!(this.getRequestScheme().equals("http") && port == 80 || this.getRequestScheme().equals("https") && port == 8080)) {
                host = host + ":" + port;
            }
        }
        return host;
    }

    public ServerConnection getConnection() {
        return this.connection;
    }

    public boolean isPersistent() {
        return Bits.anyAreSet(this.state, 16384);
    }

    public boolean isInIoThread() {
        return this.getIoThread() == Thread.currentThread();
    }

    public boolean isUpgrade() {
        return this.getResponseCode() == 101;
    }

    public void setPersistent(boolean persistent) {
        this.state = persistent ? (this.state |= 0x4000) : (this.state &= 0xFFFFBFFF);
    }

    public boolean isDispatched() {
        return Bits.anyAreSet(this.state, 32768);
    }

    public void unDispatch() {
        this.state &= 0xFFFF7FFF;
        this.dispatchExecutor = null;
        this.dispatchTask = null;
    }

    public void dispatch() {
        this.state |= 0x8000;
    }

    public void dispatch(Runnable runnable) {
        this.dispatch(null, runnable);
    }

    public void dispatch(Executor executor, Runnable runnable) {
        if (this.isInCall()) {
            this.state |= 0x8000;
            if (executor != null) {
                this.dispatchExecutor = executor;
            }
            this.dispatchTask = runnable;
        } else if (executor == null) {
            this.getConnection().getWorker().execute(runnable);
        } else {
            executor.execute(runnable);
        }
    }

    public void dispatch(HttpHandler handler) {
        this.dispatch(null, handler);
    }

    public void dispatch(Executor executor, final HttpHandler handler) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Connectors.executeRootHandler(handler, HttpServerExchange.this);
            }
        };
        this.dispatch(executor, runnable);
    }

    public void setDispatchExecutor(Executor executor) {
        this.dispatchExecutor = executor == null ? null : executor;
    }

    public Executor getDispatchExecutor() {
        return this.dispatchExecutor;
    }

    Runnable getDispatchTask() {
        return this.dispatchTask;
    }

    boolean isInCall() {
        return Bits.anyAreSet(this.state, 131072);
    }

    void setInCall(boolean value) {
        this.state = value ? (this.state |= 0x20000) : (this.state &= 0xFFFDFFFF);
    }

    public void upgradeChannel(ExchangeCompletionListener upgradeCompleteListener) {
        this.setResponseCode(101);
        this.getResponseHeaders().put(Headers.CONNECTION, "Upgrade");
        int exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners.length == exchangeCompletionListenersCount) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            System.arraycopy(old, 0, exchangeCompleteListeners, 1, exchangeCompletionListenersCount);
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        } else {
            for (int i = exchangeCompletionListenersCount - 1; i >= 0; --i) {
                exchangeCompleteListeners[i + 1] = exchangeCompleteListeners[i];
            }
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        }
    }

    public void upgradeChannel(String productName, ExchangeCompletionListener upgradeCompleteListener) {
        this.setResponseCode(101);
        HeaderMap headers = this.getResponseHeaders();
        headers.put(Headers.UPGRADE, productName);
        headers.put(Headers.CONNECTION, "Upgrade");
        int exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners.length == exchangeCompletionListenersCount) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            System.arraycopy(old, 0, exchangeCompleteListeners, 1, exchangeCompletionListenersCount);
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        } else {
            for (int i = exchangeCompletionListenersCount - 1; i >= 0; --i) {
                exchangeCompleteListeners[i + 1] = exchangeCompleteListeners[i];
            }
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        }
    }

    public void addExchangeCompleteListener(ExchangeCompletionListener listener) {
        int exchangeCompletionListenersCount;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners.length == (exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++)) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            System.arraycopy(old, 0, exchangeCompleteListeners, 0, exchangeCompletionListenersCount);
        }
        exchangeCompleteListeners[exchangeCompletionListenersCount] = listener;
    }

    public void addDefaultResponseListener(DefaultResponseListener listener) {
        int i;
        for (i = 0; i != this.defaultResponseListeners.length && this.defaultResponseListeners[i] != null; ++i) {
        }
        if (i == this.defaultResponseListeners.length) {
            DefaultResponseListener[] old = this.defaultResponseListeners;
            this.defaultResponseListeners = new DefaultResponseListener[this.defaultResponseListeners.length + 2];
            System.arraycopy(old, 0, this.defaultResponseListeners, 0, old.length);
        }
        this.defaultResponseListeners[i] = listener;
    }

    public InetSocketAddress getSourceAddress() {
        if (this.sourceAddress != null) {
            return this.sourceAddress;
        }
        return this.connection.getPeerAddress(InetSocketAddress.class);
    }

    public void setSourceAddress(InetSocketAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public InetSocketAddress getDestinationAddress() {
        return this.connection.getLocalAddress(InetSocketAddress.class);
    }

    public HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public long getRequestContentLength() {
        String contentLengthString = this.requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public HeaderMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public long getResponseContentLength() {
        String contentLengthString = this.responseHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public void setResponseContentLength(long length) {
        if (length == -1L) {
            this.responseHeaders.remove(Headers.CONTENT_LENGTH);
        } else {
            this.responseHeaders.put(Headers.CONTENT_LENGTH, Long.toString(length));
        }
    }

    public Map<String, Deque<String>> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        return this.queryParameters;
    }

    public void addQueryParam(String name, String param) {
        Deque<String> list;
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.queryParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.queryParameters.put(name, list);
        }
        list.add(param);
    }

    public Map<String, Deque<String>> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        return this.pathParameters;
    }

    public void addPathParam(String name, String param) {
        Deque<String> list;
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.pathParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.pathParameters.put(name, list);
        }
        list.add(param);
    }

    public Map<String, Cookie> getRequestCookies() {
        if (this.requestCookies == null) {
            this.requestCookies = Cookies.parseRequestCookies(this.getConnection().getUndertowOptions().get(UndertowOptions.MAX_COOKIES, 200), this.requestHeaders.get(Headers.COOKIE));
        }
        return this.requestCookies;
    }

    public void setResponseCookie(Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new TreeMap<String, Cookie>();
        }
        this.responseCookies.put(cookie.getName(), cookie);
    }

    public Map<String, Cookie> getResponseCookies() {
        if (this.responseCookies == null) {
            this.responseCookies = new TreeMap<String, Cookie>();
        }
        return this.responseCookies;
    }

    Map<String, Cookie> getResponseCookiesInternal() {
        return this.responseCookies;
    }

    public boolean isResponseStarted() {
        return Bits.allAreSet(this.state, 1024);
    }

    public StreamSourceChannel getRequestChannel() {
        if (this.requestChannel != null) {
            return null;
        }
        if (Bits.anyAreSet(this.state, 4096)) {
            this.requestChannel = new ReadDispatchChannel(new EmptyStreamSourceChannel(this.getIoThread()));
            return this.requestChannel;
        }
        ConduitWrapper<StreamSourceConduit>[] wrappers = this.requestWrappers;
        ConduitStreamSourceChannel sourceChannel = this.connection.getSourceChannel();
        if (wrappers != null) {
            this.requestWrappers = null;
            WrapperConduitFactory<StreamSourceConduit> factory = new WrapperConduitFactory<StreamSourceConduit>(wrappers, this.requestWrapperCount, sourceChannel.getConduit(), this);
            sourceChannel.setConduit(factory.create());
        }
        this.requestChannel = new ReadDispatchChannel(sourceChannel);
        return this.requestChannel;
    }

    public boolean isRequestChannelAvailable() {
        return this.requestChannel == null;
    }

    public boolean isComplete() {
        return Bits.allAreSet(this.state, 6144);
    }

    void terminateRequest() {
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 4096)) {
            return;
        }
        if (this.requestChannel != null) {
            this.requestChannel.requestDone();
        }
        this.state = oldVal | 0x1000;
        if (Bits.anyAreSet(oldVal, 2048)) {
            this.invokeExchangeCompleteListeners();
        }
    }

    private void invokeExchangeCompleteListeners() {
        if (this.exchangeCompletionListenersCount > 0) {
            int i = this.exchangeCompletionListenersCount - 1;
            ExchangeCompletionListener next = this.exchangeCompleteListeners[i];
            next.exchangeEvent(this, new ExchangeCompleteNextListener(this.exchangeCompleteListeners, this, i));
        }
    }

    public StreamSinkChannel getResponseChannel() {
        ConduitWrapper<StreamSinkConduit>[] wrappers = this.responseWrappers;
        this.responseWrappers = null;
        if (wrappers == null) {
            return null;
        }
        ConduitStreamSinkChannel sinkChannel = this.connection.getSinkChannel();
        if (sinkChannel == null) {
            return null;
        }
        WrapperConduitFactory<StreamSinkConduit> factory = new WrapperConduitFactory<StreamSinkConduit>(wrappers, this.responseWrapperCount, sinkChannel.getConduit(), this);
        sinkChannel.setConduit(factory.create());
        this.responseChannel = new WriteDispatchChannel(sinkChannel);
        this.startResponse();
        return this.responseChannel;
    }

    public Sender getResponseSender() {
        if (this.blockingHttpExchange != null) {
            return this.blockingHttpExchange.getSender();
        }
        if (this.sender != null) {
            return this.sender;
        }
        this.sender = new AsyncSenderImpl(this);
        return this.sender;
    }

    public boolean isResponseChannelAvailable() {
        return this.responseWrappers != null;
    }

    public void setResponseCode(int responseCode) {
        if (responseCode < 0 || responseCode > 999) {
            throw new IllegalArgumentException("Invalid response code");
        }
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal & ~MASK_RESPONSE_CODE | responseCode & MASK_RESPONSE_CODE;
    }

    public void addRequestWrapper(ConduitWrapper<StreamSourceConduit> wrapper) {
        ConduitWrapper<StreamSourceConduit>[] wrappers = this.requestWrappers;
        if (this.requestChannel != null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        if (wrappers == null) {
            wrappers = this.requestWrappers = new ConduitWrapper[2];
        } else if (wrappers.length == this.requestWrapperCount) {
            this.requestWrappers = new ConduitWrapper[wrappers.length + 2];
            System.arraycopy(wrappers, 0, this.requestWrappers, 0, wrappers.length);
            wrappers = this.requestWrappers;
        }
        wrappers[this.requestWrapperCount++] = wrapper;
    }

    public void addResponseWrapper(ConduitWrapper<StreamSinkConduit> wrapper) {
        ConduitWrapper<StreamSinkConduit>[] wrappers = this.responseWrappers;
        if (wrappers == null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        if (wrappers.length == this.responseWrapperCount) {
            this.responseWrappers = new ConduitWrapper[wrappers.length + 2];
            System.arraycopy(wrappers, 0, this.responseWrappers, 0, wrappers.length);
            wrappers = this.responseWrappers;
        }
        wrappers[this.responseWrapperCount++] = wrapper;
    }

    public BlockingHttpExchange startBlocking() {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = new DefaultBlockingHttpExchange(this);
        return old;
    }

    public BlockingHttpExchange startBlocking(BlockingHttpExchange httpExchange) {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = httpExchange;
        return old;
    }

    public InputStream getInputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getOutputStream();
    }

    public int getResponseCode() {
        return this.state & MASK_RESPONSE_CODE;
    }

    void terminateResponse() {
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 2048)) {
            return;
        }
        this.responseChannel.responseDone();
        this.state = oldVal | 0x800;
        if (Bits.anyAreSet(oldVal, 4096)) {
            this.invokeExchangeCompleteListeners();
        }
    }

    public void endExchange() {
        final int state = this.state;
        if (Bits.allAreSet(state, 6144)) {
            return;
        }
        for (int i = this.defaultResponseListeners.length - 1; i >= 0; --i) {
            DefaultResponseListener listener = this.defaultResponseListeners[i];
            if (listener == null) continue;
            this.defaultResponseListeners[i] = null;
            try {
                if (!listener.handleDefaultResponse(this)) continue;
                return;
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception running default response listener", e);
            }
        }
        if (this.blockingHttpExchange != null) {
            try {
                this.blockingHttpExchange.close();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.connection);
            }
        }
        if (Bits.anyAreClear(state, 4096)) {
            if (this.requestChannel == null) {
                this.getRequestChannel();
            }
            int totalRead = 0;
            try {
                long read;
                do {
                    read = Channels.drain(this.requestChannel, Long.MAX_VALUE);
                    totalRead = (int)((long)totalRead + read);
                    if (read != 0L) continue;
                    if (this.getResponseCode() != 417 || totalRead > 0) {
                        this.requestChannel.getReadSetter().set(ChannelListeners.drainListener(Long.MAX_VALUE, new ChannelListener<StreamSourceChannel>(){

                            @Override
                            public void handleEvent(StreamSourceChannel channel) {
                                if (Bits.anyAreClear(state, 2048)) {
                                    HttpServerExchange.this.closeAndFlushResponse();
                                }
                            }
                        }, new ChannelExceptionHandler<StreamSourceChannel>(){

                            @Override
                            public void handleException(StreamSourceChannel channel, IOException e) {
                                UndertowLogger.REQUEST_LOGGER.debug("Exception draining request stream", e);
                                IoUtils.safeClose((Closeable)HttpServerExchange.this.connection);
                            }
                        }));
                        this.requestChannel.resumeReads();
                        return;
                    }
                    break;
                } while (read != -1L);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.connection);
            }
        }
        if (Bits.anyAreClear(state, 2048)) {
            this.closeAndFlushResponse();
        }
    }

    private void closeAndFlushResponse() {
        try {
            if (this.isResponseChannelAvailable()) {
                this.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                this.getResponseChannel();
            }
            this.responseChannel.shutdownWrites();
            if (!this.responseChannel.flush()) {
                this.responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                    @Override
                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        channel.getWriteSetter().set(null);
                    }
                }, new ChannelExceptionHandler<Channel>(){

                    @Override
                    public void handleException(Channel channel, IOException exception) {
                        UndertowLogger.REQUEST_LOGGER.debug("Exception ending request", exception);
                        IoUtils.safeClose((Closeable)HttpServerExchange.this.connection);
                    }
                }));
                this.responseChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)this.connection);
        }
    }

    void startResponse() throws IllegalStateException {
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal | 0x400;
        log.tracef("Starting to write response for %s", (Object)this);
    }

    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    public long getMaxEntitySize() {
        return this.maxEntitySize;
    }

    public void setMaxEntitySize(long maxEntitySize) {
        if (!this.isRequestChannelAvailable()) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        this.maxEntitySize = maxEntitySize;
    }

    public String toString() {
        return "HttpServerExchange{ " + this.getRequestMethod().toString() + " " + this.getRequestURI() + '}';
    }

    public static class WrapperConduitFactory<T extends Conduit>
    implements ConduitFactory<T> {
        private final HttpServerExchange exchange;
        private final ConduitWrapper<T>[] wrappers;
        private final int wrapperCount;
        private int position;
        private T first;

        public WrapperConduitFactory(ConduitWrapper<T>[] wrappers, int wrapperCount, T first, HttpServerExchange exchange) {
            this.wrappers = wrappers;
            this.wrapperCount = wrapperCount;
            this.exchange = exchange;
            this.position = wrapperCount - 1;
            this.first = first;
        }

        @Override
        public T create() {
            if (this.position == -1) {
                return this.first;
            }
            return this.wrappers[this.position--].wrap(this, this.exchange);
        }
    }

    private final class ReadDispatchChannel
    extends DetachableStreamSourceChannel
    implements StreamSourceChannel,
    Runnable {
        private boolean wakeup;

        public ReadDispatchChannel(StreamSourceChannel delegate) {
            super(delegate);
            this.wakeup = true;
        }

        @Override
        protected boolean isFinished() {
            return Bits.allAreSet(HttpServerExchange.this.state, 4096);
        }

        @Override
        public void resumeReads() {
            if (this.isFinished()) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = false;
                HttpServerExchange.this.dispatch(SameThreadExecutor.INSTANCE, this);
            } else {
                this.delegate.resumeReads();
            }
        }

        @Override
        public void wakeupReads() {
            if (this.isFinished()) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = true;
                HttpServerExchange.this.dispatch(SameThreadExecutor.INSTANCE, this);
            } else {
                this.delegate.wakeupReads();
            }
        }

        @Override
        public void run() {
            if (!this.isFinished()) {
                if (this.wakeup) {
                    this.delegate.wakeupReads();
                } else {
                    this.delegate.resumeReads();
                }
            }
        }

        public void requestDone() {
            this.delegate.getReadSetter().set(null);
            this.delegate.getCloseSetter().set(null);
            if (this.delegate.isReadResumed()) {
                this.delegate.suspendReads();
            }
        }
    }

    private class WriteDispatchChannel
    extends DetachableStreamSinkChannel
    implements StreamSinkChannel,
    Runnable {
        private boolean wakeup;

        public WriteDispatchChannel(StreamSinkChannel delegate) {
            super(delegate);
        }

        @Override
        protected boolean isFinished() {
            return Bits.allAreSet(HttpServerExchange.this.state, 2048);
        }

        @Override
        public void resumeWrites() {
            if (this.isFinished()) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = false;
                HttpServerExchange.this.dispatch(SameThreadExecutor.INSTANCE, this);
            } else {
                this.delegate.resumeWrites();
            }
        }

        @Override
        public void wakeupWrites() {
            if (this.isFinished()) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = true;
                HttpServerExchange.this.dispatch(SameThreadExecutor.INSTANCE, this);
            } else {
                this.delegate.wakeupWrites();
            }
        }

        @Override
        public void run() {
            if (this.wakeup) {
                this.delegate.wakeupWrites();
            } else {
                this.delegate.resumeWrites();
            }
        }

        @Override
        public void responseDone() {
            this.delegate.getCloseSetter().set(null);
            this.delegate.getWriteSetter().set(null);
            if (this.delegate.isWriteResumed()) {
                this.delegate.suspendWrites();
            }
        }
    }

    private static class DefaultBlockingHttpExchange
    implements BlockingHttpExchange {
        private InputStream inputStream;
        private OutputStream outputStream;
        private Sender sender;
        private final HttpServerExchange exchange;

        DefaultBlockingHttpExchange(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = new UndertowInputStream(this.exchange);
            }
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = new UndertowOutputStream(this.exchange);
            }
            return this.outputStream;
        }

        @Override
        public Sender getSender() {
            if (this.sender == null) {
                this.sender = new BlockingSenderImpl(this.exchange, this.getOutputStream());
            }
            return this.sender;
        }

        @Override
        public void close() throws IOException {
            IoUtils.safeClose((Closeable)this.getInputStream());
            IoUtils.safeClose((Closeable)this.getOutputStream());
        }
    }

    private static class ExchangeCompleteNextListener
    implements ExchangeCompletionListener.NextListener {
        private final ExchangeCompletionListener[] list;
        private final HttpServerExchange exchange;
        private int i;

        public ExchangeCompleteNextListener(ExchangeCompletionListener[] list, HttpServerExchange exchange, int i) {
            this.list = list;
            this.exchange = exchange;
            this.i = i;
        }

        @Override
        public void proceed() {
            if (--this.i >= 0) {
                ExchangeCompletionListener next = this.list[this.i];
                next.exchangeEvent(this.exchange, this);
            }
        }
    }
}

