/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class URLUtils {
    private static final QueryStringParser QUERY_STRING_PARSER = new QueryStringParser(){

        @Override
        void handle(HttpServerExchange exchange, String key, String value) {
            exchange.addQueryParam(key, value);
        }
    };
    private static final QueryStringParser PATH_PARAM_PARSER = new QueryStringParser(){

        @Override
        void handle(HttpServerExchange exchange, String key, String value) {
            exchange.addPathParam(key, value);
        }
    };

    public static void parseQueryString(String string, HttpServerExchange exchange, String charset) {
        QUERY_STRING_PARSER.parse(string, exchange, charset);
    }

    public static void parsePathParms(String string, HttpServerExchange exchange, String charset) {
        PATH_PARAM_PARSER.parse(string, exchange, charset);
    }

    private URLUtils() {
    }

    private static abstract class QueryStringParser {
        private QueryStringParser() {
        }

        void parse(String string, HttpServerExchange exchange, String charset) {
            try {
                int stringStart = 0;
                String attrName = null;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '=' && attrName == null) {
                        attrName = string.substring(stringStart, i);
                        stringStart = i + 1;
                        continue;
                    }
                    if (c != '&') continue;
                    if (attrName != null) {
                        this.handle(exchange, URLDecoder.decode(attrName, charset), URLDecoder.decode(string.substring(stringStart, i), charset));
                    } else {
                        this.handle(exchange, URLDecoder.decode(string.substring(stringStart, i), charset), "");
                    }
                    stringStart = i + 1;
                    attrName = null;
                }
                if (attrName != null) {
                    this.handle(exchange, URLDecoder.decode(attrName, charset), URLDecoder.decode(string.substring(stringStart, string.length()), charset));
                } else if (string.length() != stringStart) {
                    this.handle(exchange, URLDecoder.decode(string.substring(stringStart, string.length()), charset), "");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        abstract void handle(HttpServerExchange var1, String var2, String var3);
    }
}

