/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.channels.SslConnection;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.JsseSslConduitEngine;
import org.xnio.ssl.JsseSslStreamSinkConduit;
import org.xnio.ssl.JsseSslStreamSourceConduit;

final class JsseSslStreamConnection
extends SslConnection {
    private final StreamConnection connection;
    private final JsseSslConduitEngine sslConduitEngine;
    private volatile boolean tls;
    private final ChannelListener.SimpleSetter<SslConnection> handshakeSetter = new ChannelListener.SimpleSetter();

    JsseSslStreamConnection(StreamConnection connection, SSLEngine sslEngine, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool, boolean startTls) {
        super(connection.getIoThread());
        this.connection = connection;
        StreamSinkConduit sinkConduit = connection.getSinkChannel().getConduit();
        StreamSourceConduit sourceConduit = connection.getSourceChannel().getConduit();
        this.sslConduitEngine = new JsseSslConduitEngine(this, sinkConduit, sourceConduit, sslEngine, socketBufferPool, applicationBufferPool);
        this.tls = !startTls;
        this.setSinkConduit(new JsseSslStreamSinkConduit(sinkConduit, this.sslConduitEngine, this.tls));
        this.setSourceConduit(new JsseSslStreamSourceConduit(sourceConduit, this.sslConduitEngine, this.tls));
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        if (!this.tls) {
            this.tls = true;
            ((JsseSslStreamSourceConduit)this.getSourceChannel().getConduit()).enableTls();
            ((JsseSslStreamSinkConduit)this.getSinkChannel().getConduit()).enableTls();
        }
        this.sslConduitEngine.beginHandshake();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connection.getPeerAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    protected void closeAction() throws IOException {
        if (this.tls) {
            this.sslConduitEngine.closeOutbound();
            this.sslConduitEngine.closeInbound();
        }
        this.connection.close();
    }

    @Override
    protected void notifyWriteClosed() {
    }

    @Override
    protected void notifyReadClosed() {
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.connection.setOption(option, value);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return option == Options.SECURE ? option.cast(this.tls) : this.connection.getOption(option);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return option == Options.SECURE || this.connection.supportsOption(option);
    }

    @Override
    public SSLSession getSslSession() {
        return this.tls ? this.sslConduitEngine.getSession() : null;
    }

    @Override
    public ChannelListener.Setter<? extends SslConnection> getHandshakeSetter() {
        return this.handshakeSetter;
    }

    SSLEngine getEngine() {
        return this.sslConduitEngine.getEngine();
    }

    protected void handleHandshakeFinished() {
        ChannelListener<SslConnection> listener = this.handshakeSetter.get();
        if (listener == null) {
            return;
        }
        ChannelListeners.invokeChannelListener(this, listener);
    }
}

