/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

public class ChunkedStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static final AttachmentKey<HeaderMap> TRAILERS = AttachmentKey.create(HeaderMap.class);
    private final HeaderMap responseHeaders;
    private final ConduitListener<? super ChunkedStreamSinkConduit> finishListener;
    private final int config;
    private static final byte[] LAST_CHUNK = "0\r\n".getBytes();
    public static final byte[] CRLF = "\r\n".getBytes();
    private final Attachable attachable;
    private int state;
    private int chunkleft = 0;
    private final ByteBuffer chunkingBuffer = ByteBuffer.allocate(14);
    private ByteBuffer trailerBuffer;
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final int FLAG_WRITES_SHUTDOWN = 1;
    private static final int FLAG_NEXT_SHUTDWON = 4;
    private static final int FLAG_WRITTEN_FIRST_CHUNK = 8;
    int written = 0;

    public ChunkedStreamSinkConduit(StreamSinkConduit next, boolean configurable, boolean passClose, HeaderMap responseHeaders, ConduitListener<? super ChunkedStreamSinkConduit> finishListener, Attachable attachable) {
        super(next);
        this.responseHeaders = responseHeaders;
        this.finishListener = finishListener;
        this.attachable = attachable;
        this.config = (configurable ? 1 : 0) | (passClose ? 2 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (this.chunkleft == 0) {
            this.chunkingBuffer.clear();
            if (Bits.anyAreSet(this.state, 8)) {
                this.chunkingBuffer.put(CRLF);
            }
            this.written += src.remaining();
            this.chunkingBuffer.put(Integer.toHexString(src.remaining()).getBytes());
            this.chunkingBuffer.put(CRLF);
            this.chunkingBuffer.flip();
            this.state |= 8;
            int chunkingSize = this.chunkingBuffer.remaining();
            ByteBuffer[] buf = new ByteBuffer[]{this.chunkingBuffer, src};
            long result = ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
            this.chunkleft = src.remaining();
            if (result < (long)chunkingSize) {
                return 0;
            }
            return (int)(result - (long)chunkingSize);
        }
        int oldLimit = src.limit();
        if (src.remaining() > this.chunkleft) {
            src.limit(this.chunkleft + src.position());
        }
        try {
            int chunkingSize = this.chunkingBuffer.remaining();
            if (chunkingSize > 0) {
                ByteBuffer[] buf = new ByteBuffer[]{this.chunkingBuffer, src};
                int origialRemaining = src.remaining();
                long result = ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
                int srcWritten = origialRemaining - src.remaining();
                this.chunkleft -= srcWritten;
                if (result < (long)chunkingSize) {
                    int n = 0;
                    return n;
                }
                int n = (int)(result - (long)chunkingSize);
                return n;
            }
            int result = ((StreamSinkConduit)this.next).write(src);
            this.chunkleft -= result;
            int n = result;
            return n;
        }
        finally {
            src.limit(oldLimit);
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            return this.write(srcs[i]);
        }
        return 0L;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            if (Bits.anyAreSet(this.state, 4)) {
                return ((StreamSinkConduit)this.next).flush();
            }
            if (this.trailerBuffer == null) {
                ((StreamSinkConduit)this.next).write(this.chunkingBuffer);
            } else {
                ((StreamSinkConduit)this.next).write(new ByteBuffer[]{this.chunkingBuffer, this.trailerBuffer}, 0, 2);
            }
            if (!(this.chunkingBuffer.hasRemaining() || this.trailerBuffer != null && this.trailerBuffer.hasRemaining())) {
                this.trailerBuffer = null;
                try {
                    if (Bits.anyAreSet(this.config, 2)) {
                        ((StreamSinkConduit)this.next).terminateWrites();
                    }
                    this.state |= 4;
                    boolean bl = ((StreamSinkConduit)this.next).flush();
                    return bl;
                }
                finally {
                    if (this.finishListener != null) {
                        this.finishListener.handleEvent(this);
                    }
                }
            }
            return false;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.chunkleft != 0) {
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
        this.chunkingBuffer.clear();
        if (!Bits.anyAreSet(this.state, 8)) {
            this.responseHeaders.put(Headers.CONTENT_LENGTH, "0");
            this.responseHeaders.remove(Headers.TRANSFER_ENCODING);
            this.state |= 5;
            ((StreamSinkConduit)this.next).terminateWrites();
            return;
        }
        this.chunkingBuffer.put(CRLF);
        this.chunkingBuffer.put(LAST_CHUNK);
        HeaderMap trailers = this.attachable.getAttachment(TRAILERS);
        if (trailers != null && trailers.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (HeaderValues trailer : trailers) {
                for (String val : trailer) {
                    sb.append(trailer.getHeaderName().toString());
                    sb.append(": ");
                    sb.append(val);
                    sb.append("\r\n");
                }
            }
            sb.append("\r\n");
            this.trailerBuffer = ByteBuffer.wrap(sb.toString().getBytes("US-ASCII"));
        } else {
            this.chunkingBuffer.put(CRLF);
        }
        this.chunkingBuffer.flip();
        this.state |= 1;
    }

    @Override
    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }
}

