/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.FinishableStreamSinkConduit;
import io.undertow.conduits.FinishableStreamSourceConduit;
import io.undertow.conduits.FixedLengthStreamSinkConduit;
import io.undertow.conduits.FixedLengthStreamSourceConduit;
import io.undertow.conduits.HeadStreamSinkConduit;
import io.undertow.conduits.PipelingBufferingStreamSinkConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpResponseConduit;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.ConduitFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import org.jboss.logging.Logger;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class HttpTransferEncoding {
    private static final Logger log = Logger.getLogger("io.undertow.server.handler.transfer-encoding");

    private HttpTransferEncoding() {
    }

    public static void setupRequest(HttpServerExchange exchange) {
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        String connectionHeader = requestHeaders.getFirst(Headers.CONNECTION);
        String transferEncodingHeader = requestHeaders.getLast(Headers.TRANSFER_ENCODING);
        String contentLengthHeader = requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        HttpServerConnection connection = (HttpServerConnection)exchange.getConnection();
        ConduitStreamSinkChannel sinkChannel = connection.getChannel().getSinkChannel();
        PipelingBufferingStreamSinkConduit pipeliningBuffer = connection.getAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY);
        if (pipeliningBuffer != null) {
            pipeliningBuffer.setupPipelineBuffer(exchange);
        }
        ConduitStreamSourceChannel sourceChannel = connection.getChannel().getSourceChannel();
        sourceChannel.setConduit(new ReadDataStreamSourceConduit(sourceChannel.getConduit(), connection));
        boolean persistentConnection = HttpTransferEncoding.persistentConnection(exchange, connectionHeader);
        if (exchange.getRequestMethod().equals(Methods.GET)) {
            if (persistentConnection && connection.getExtraBytes() != null && pipeliningBuffer == null && connection.getUndertowOptions().get(UndertowOptions.BUFFER_PIPELINED_DATA, false)) {
                pipeliningBuffer = new PipelingBufferingStreamSinkConduit(connection.getOriginalSinkConduit(), connection.getBufferPool());
                connection.putAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY, pipeliningBuffer);
                pipeliningBuffer.setupPipelineBuffer(exchange);
            }
            Connectors.terminateRequest(exchange);
        } else {
            persistentConnection = HttpTransferEncoding.handleRequestEncoding(exchange, transferEncodingHeader, contentLengthHeader, connection, pipeliningBuffer, persistentConnection);
        }
        exchange.setPersistent(persistentConnection);
        sinkChannel.setConduit(new HttpResponseConduit(sinkChannel.getConduit(), connection.getBufferPool(), exchange));
        exchange.addResponseWrapper(HttpTransferEncoding.responseWrapper());
    }

    private static boolean handleRequestEncoding(final HttpServerExchange exchange, String transferEncodingHeader, String contentLengthHeader, HttpServerConnection connection, PipelingBufferingStreamSinkConduit pipeliningBuffer, boolean persistentConnection) {
        HttpString transferEncoding = Headers.IDENTITY;
        if (transferEncodingHeader != null) {
            transferEncoding = new HttpString(transferEncodingHeader);
        }
        if (transferEncodingHeader != null && !transferEncoding.equals(Headers.IDENTITY)) {
            ConduitStreamSourceChannel sourceChannel = ((HttpServerConnection)exchange.getConnection()).getChannel().getSourceChannel();
            sourceChannel.setConduit(new ChunkedStreamSourceConduit(sourceChannel.getConduit(), exchange, HttpTransferEncoding.chunkedDrainListener(exchange)));
        } else if (contentLengthHeader != null) {
            long contentLength = Long.parseLong(contentLengthHeader);
            if (contentLength == 0L) {
                log.trace("No content, starting next request");
                Connectors.terminateRequest(exchange);
            } else {
                ConduitStreamSourceChannel sourceChannel = ((HttpServerConnection)exchange.getConnection()).getChannel().getSourceChannel();
                sourceChannel.setConduit(HttpTransferEncoding.fixedLengthStreamSourceConduitWrapper(contentLength, sourceChannel.getConduit(), exchange));
            }
        } else if (transferEncodingHeader != null) {
            if (transferEncoding.equals(Headers.IDENTITY)) {
                log.trace("Connection not persistent (no content length and identity transfer encoding)");
                persistentConnection = false;
            }
        } else if (persistentConnection) {
            if (connection.getExtraBytes() != null && pipeliningBuffer == null && connection.getUndertowOptions().get(UndertowOptions.BUFFER_PIPELINED_DATA, false)) {
                pipeliningBuffer = new PipelingBufferingStreamSinkConduit(connection.getOriginalSinkConduit(), connection.getBufferPool());
                connection.putAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY, pipeliningBuffer);
                pipeliningBuffer.setupPipelineBuffer(exchange);
            }
            Connectors.terminateRequest(exchange);
        } else if (exchange.isHttp11()) {
            Connectors.terminateRequest(exchange);
        } else {
            ConduitStreamSourceChannel sourceChannel = ((HttpServerConnection)exchange.getConnection()).getChannel().getSourceChannel();
            sourceChannel.setConduit(new FinishableStreamSourceConduit(sourceChannel.getConduit(), (ConduitListener<? super FinishableStreamSourceConduit>)new ConduitListener<FinishableStreamSourceConduit>(){

                @Override
                public void handleEvent(FinishableStreamSourceConduit channel) {
                    Connectors.terminateRequest(exchange);
                }
            }));
        }
        return persistentConnection;
    }

    private static boolean persistentConnection(HttpServerExchange exchange, String connectionHeader) {
        if (exchange.isHttp11()) {
            return connectionHeader == null || !Headers.CLOSE.equalToString(connectionHeader);
        }
        if (exchange.isHttp10() && connectionHeader != null && Headers.KEEP_ALIVE.equals(new HttpString(connectionHeader))) {
            return true;
        }
        log.trace("Connection not persistent");
        return false;
    }

    private static ConduitWrapper<StreamSinkConduit> responseWrapper() {
        return HttpResponseWrapper.INSTANCE;
    }

    private static StreamSourceConduit fixedLengthStreamSourceConduitWrapper(long contentLength, StreamSourceConduit conduit, HttpServerExchange exchange) {
        return new FixedLengthStreamSourceConduit(conduit, contentLength, HttpTransferEncoding.fixedLengthDrainListener(exchange), exchange);
    }

    private static ConduitListener<FixedLengthStreamSourceConduit> fixedLengthDrainListener(final HttpServerExchange exchange) {
        return new ConduitListener<FixedLengthStreamSourceConduit>(){

            @Override
            public void handleEvent(FixedLengthStreamSourceConduit fixedLengthConduit) {
                long remaining = fixedLengthConduit.getRemaining();
                if (remaining > 0L) {
                    UndertowLogger.REQUEST_LOGGER.requestWasNotFullyConsumed();
                    exchange.setPersistent(false);
                }
                Connectors.terminateRequest(exchange);
            }
        };
    }

    private static ConduitListener<ChunkedStreamSourceConduit> chunkedDrainListener(final HttpServerExchange exchange) {
        return new ConduitListener<ChunkedStreamSourceConduit>(){

            @Override
            public void handleEvent(ChunkedStreamSourceConduit chunkedStreamSourceConduit) {
                if (!chunkedStreamSourceConduit.isFinished()) {
                    UndertowLogger.REQUEST_LOGGER.requestWasNotFullyConsumed();
                    exchange.setPersistent(false);
                }
                Connectors.terminateRequest(exchange);
            }
        };
    }

    private static ConduitListener<StreamSinkConduit> terminateResponseListener(final HttpServerExchange exchange) {
        return new ConduitListener<StreamSinkConduit>(){

            @Override
            public void handleEvent(StreamSinkConduit channel) {
                Connectors.terminateResponse(exchange);
            }
        };
    }

    private static class HttpResponseWrapper
    implements ConduitWrapper<StreamSinkConduit> {
        public static final HttpResponseWrapper INSTANCE = new HttpResponseWrapper();

        private HttpResponseWrapper() {
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            String transferEncodingHeader;
            StreamSinkConduit channel = factory.create();
            ConduitListener finishListener = HttpTransferEncoding.terminateResponseListener(exchange);
            if (exchange.getRequestMethod().equals(Methods.HEAD)) {
                channel = new HeadStreamSinkConduit(channel, null);
            }
            HeaderMap responseHeaders = exchange.getResponseHeaders();
            String connection = responseHeaders.getFirst(Headers.CONNECTION);
            if (!exchange.isPersistent()) {
                responseHeaders.put(Headers.CONNECTION, Headers.CLOSE.toString());
            } else if (exchange.isPersistent() && connection != null) {
                if (HttpString.tryFromString(connection).equals(Headers.CLOSE)) {
                    exchange.setPersistent(false);
                }
            } else if (exchange.getConnection().getUndertowOptions().get(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, true)) {
                responseHeaders.put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
            }
            String contentLengthHeader = responseHeaders.getFirst(Headers.CONTENT_LENGTH);
            if (contentLengthHeader != null) {
                try {
                    long contentLength = Long.parseLong(contentLengthHeader);
                    return new FixedLengthStreamSinkConduit(channel, contentLength, true, !exchange.isPersistent(), finishListener);
                }
                catch (NumberFormatException e) {
                    responseHeaders.remove(Headers.CONTENT_LENGTH);
                }
            }
            if ((transferEncodingHeader = responseHeaders.getLast(Headers.TRANSFER_ENCODING)) == null) {
                if (exchange.isHttp11()) {
                    responseHeaders.put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
                    return new ChunkedStreamSinkConduit(channel, true, !exchange.isPersistent(), responseHeaders, finishListener, exchange);
                }
                exchange.setPersistent(false);
                responseHeaders.put(Headers.CONNECTION, Headers.CLOSE.toString());
                return new FinishableStreamSinkConduit(channel, finishListener);
            }
            return this.handleExplicitTransferEncoding(exchange, channel, finishListener, responseHeaders, transferEncodingHeader);
        }

        private StreamSinkConduit handleExplicitTransferEncoding(HttpServerExchange exchange, StreamSinkConduit channel, ConduitListener<StreamSinkConduit> finishListener, HeaderMap responseHeaders, String transferEncodingHeader) {
            HttpString transferEncoding = new HttpString(transferEncodingHeader);
            if (transferEncoding.equals(Headers.CHUNKED)) {
                return new ChunkedStreamSinkConduit(channel, true, !exchange.isPersistent(), responseHeaders, finishListener, exchange);
            }
            log.trace("Cancelling persistence because response is identity with no content length");
            exchange.setPersistent(false);
            responseHeaders.put(Headers.CONNECTION, Headers.CLOSE.toString());
            return new FinishableStreamSinkConduit(channel, HttpTransferEncoding.terminateResponseListener(exchange));
        }
    }
}

