/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.protocol.http.HttpServerConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.xnio.ChannelListener;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.channels.SslChannel;

public class ConnectionSSLSessionInfo
implements SSLSessionInfo {
    private final SslChannel channel;
    private final HttpServerConnection serverConnection;

    public ConnectionSSLSessionInfo(SslChannel channel, HttpServerConnection serverConnection) {
        this.channel = channel;
        this.serverConnection = serverConnection;
    }

    @Override
    public byte[] getSessionId() {
        return this.channel.getSslSession().getId();
    }

    @Override
    public String getCipherSuite() {
        return this.channel.getSslSession().getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates(boolean forceRenegotiation) throws SSLPeerUnverifiedException {
        try {
            return this.channel.getSslSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            if (forceRenegotiation) {
                AbstractServerConnection.ConduitState oldState = this.serverConnection.resetChannel();
                try {
                    SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                    if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                        SslHandshakeWaiter waiter = new SslHandshakeWaiter();
                        this.channel.getHandshakeSetter().set(waiter);
                        this.channel.setOption(Options.SSL_CLIENT_AUTH_MODE, SslClientAuthMode.REQUESTED);
                        this.channel.getSslSession().invalidate();
                        this.channel.startHandshake();
                        ByteBuffer b = ByteBuffer.wrap(new byte[1]);
                        while (!waiter.isDone()) {
                            int read = this.serverConnection.getSourceChannel().read(b);
                            if (read != 0) {
                                throw new SSLPeerUnverifiedException("");
                            }
                            if (waiter.isDone()) continue;
                            this.serverConnection.getSourceChannel().awaitReadable();
                        }
                        Certificate[] certificateArray = this.channel.getSslSession().getPeerCertificates();
                        return certificateArray;
                    }
                }
                catch (IOException e2) {
                    throw e;
                }
                finally {
                    this.serverConnection.restoreChannel(oldState);
                }
            }
            throw e;
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain(boolean forceRenegotiation) throws SSLPeerUnverifiedException {
        try {
            return this.channel.getSslSession().getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            if (forceRenegotiation) {
                AbstractServerConnection.ConduitState oldState = this.serverConnection.resetChannel();
                try {
                    SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                    if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                        SslHandshakeWaiter waiter = new SslHandshakeWaiter();
                        this.channel.getHandshakeSetter().set(waiter);
                        this.channel.setOption(Options.SSL_CLIENT_AUTH_MODE, SslClientAuthMode.REQUESTED);
                        this.channel.getSslSession().invalidate();
                        this.channel.startHandshake();
                        ByteBuffer b = ByteBuffer.wrap(new byte[1]);
                        while (!waiter.isDone()) {
                            int read = this.serverConnection.getSourceChannel().read(b);
                            if (read != 0) {
                                throw UndertowMessages.MESSAGES.couldNotRenegotiate();
                            }
                            if (waiter.isDone()) continue;
                            this.serverConnection.getSourceChannel().awaitReadable();
                        }
                        X509Certificate[] x509CertificateArray = this.channel.getSslSession().getPeerCertificateChain();
                        return x509CertificateArray;
                    }
                }
                catch (IOException e2) {
                    throw e;
                }
                finally {
                    this.serverConnection.restoreChannel(oldState);
                }
            }
            throw e;
        }
    }

    private static class SslHandshakeWaiter
    implements ChannelListener<SslChannel> {
        private volatile boolean done = false;

        private SslHandshakeWaiter() {
        }

        boolean isDone() {
            return this.done;
        }

        @Override
        public void handleEvent(SslChannel channel) {
            this.done = true;
        }
    }
}

