/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public final class HttpString
implements Comparable<HttpString>,
Serializable {
    private final byte[] bytes;
    private final transient int hashCode;
    private final int orderInt;
    private transient String string;
    private static final Field hashCodeField;
    private static final int hashCodeBase;
    public static final HttpString EMPTY;

    public HttpString(byte[] bytes) {
        this((byte[])bytes.clone(), null);
    }

    public HttpString(byte[] bytes, int offset, int length) {
        this(Arrays.copyOfRange(bytes, offset, length), null);
    }

    public HttpString(ByteBuffer buffer) {
        this(HttpString.take(buffer), null);
    }

    public HttpString(String string) {
        this(string, 0);
    }

    HttpString(String string, int orderInt) {
        this.orderInt = orderInt;
        int len = string.length();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                throw new IllegalArgumentException("Invalid string contents");
            }
            bytes[i] = (byte)c;
        }
        this.bytes = bytes;
        this.hashCode = HttpString.calcHashCode(bytes);
        this.string = string;
    }

    private HttpString(byte[] bytes, String string) {
        this.bytes = bytes;
        this.hashCode = HttpString.calcHashCode(bytes);
        this.string = string;
        this.orderInt = 0;
    }

    public static HttpString tryFromString(String string) {
        int len = string.length();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                return null;
            }
            bytes[i] = (byte)c;
        }
        return new HttpString(bytes, string);
    }

    public int length() {
        return this.bytes.length;
    }

    public byte byteAt(int idx) {
        return this.bytes[idx];
    }

    public void copyTo(int srcOffs, byte[] dst, int offs, int len) {
        System.arraycopy(this.bytes, srcOffs, dst, offs, len);
    }

    public void copyTo(byte[] dst, int offs, int len) {
        this.copyTo(0, dst, offs, len);
    }

    public void copyTo(byte[] dst, int offs) {
        this.copyTo(dst, offs, this.bytes.length);
    }

    public void appendTo(ByteBuffer buffer) {
        buffer.put(this.bytes);
    }

    public void writeTo(OutputStream output) throws IOException {
        output.write(this.bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] take(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            try {
                byte[] byArray = Arrays.copyOfRange(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                return byArray;
            }
            finally {
                buffer.position(buffer.limit());
            }
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public int compareTo(HttpString other) {
        if (this.orderInt != 0 && other.orderInt != 0) {
            return Integer.signum(this.orderInt - other.orderInt);
        }
        int len = Math.min(this.bytes.length, other.bytes.length);
        for (int i = 0; i < len; ++i) {
            int res = Integer.signum(HttpString.higher(this.bytes[i]) - HttpString.higher(other.bytes[i]));
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(this.bytes.length - other.bytes.length);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof HttpString && this.equals((HttpString)other);
    }

    public boolean equals(HttpString other) {
        return other == this || other != null && HttpString.bytesAreEqual(this.bytes, other.bytes);
    }

    private static int calcHashCode(byte[] bytes) {
        int hc = 17;
        for (byte b : bytes) {
            hc = (hc << 4) + hc + HttpString.higher(b);
        }
        return hc;
    }

    private static int higher(byte b) {
        return b & (b >= 97 && b <= 122 ? 223 : 255);
    }

    private static boolean bytesAreEqual(byte[] a, byte[] b) {
        return a.length == b.length && HttpString.bytesAreEquivalent(a, b);
    }

    private static boolean bytesAreEquivalent(byte[] a, byte[] b) {
        assert (a.length == b.length);
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (HttpString.higher(a[i]) == HttpString.higher(b[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.string == null) {
            this.string = new String(this.bytes, 0);
        }
        return this.string;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            hashCodeField.setInt(this, HttpString.calcHashCode(this.bytes));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    static int hashCodeOf(String headerName) {
        int hc = 17;
        for (int i = 0; i < headerName.length(); ++i) {
            hc = (hc << 4) + hc + HttpString.higher((byte)headerName.charAt(i));
        }
        return hc;
    }

    public boolean equalToString(String headerName) {
        if (headerName.length() != this.bytes.length) {
            return false;
        }
        int len = this.bytes.length;
        for (int i = 0; i < len; ++i) {
            if (HttpString.higher(this.bytes[i]) == HttpString.higher((byte)headerName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            hashCodeField = HttpString.class.getDeclaredField("hashCode");
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
        hashCodeBase = new Random().nextInt();
        EMPTY = new HttpString("");
    }
}

