/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeEvent;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xnio.FileChangeCallback;
import org.xnio.FileChangeEvent;
import org.xnio.FileSystemWatcher;
import org.xnio.OptionMap;
import org.xnio.Xnio;

public class FileResourceManager
implements ResourceManager {
    private final List<ResourceChangeListener> listeners = new ArrayList<ResourceChangeListener>();
    private FileSystemWatcher fileSystemWatcher;
    private volatile String base;
    private final long transferMinSize;

    public FileResourceManager(File base, long transferMinSize) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        this.transferMinSize = transferMinSize;
    }

    public File getBase() {
        return new File(this.base);
    }

    public FileResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        String path = null;
        path = p.startsWith("/") ? p.substring(1) : p;
        try {
            File file = new File(this.base, path);
            if (file.exists() && file.getCanonicalFile().getName().equals(file.getName())) {
                return new FileResource(file, this, path);
            }
            return null;
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Invalid path %s", new Object[0]);
            return null;
        }
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return true;
    }

    @Override
    public synchronized void registerResourceChangeListener(ResourceChangeListener listener) {
        this.listeners.add(listener);
        if (this.fileSystemWatcher == null) {
            this.fileSystemWatcher = Xnio.getInstance().createFileSystemWatcher("Watcher for " + this.base, OptionMap.EMPTY);
            this.fileSystemWatcher.watchPath(new File(this.base), new FileChangeCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleChanges(Collection<FileChangeEvent> changes) {
                    FileResourceManager fileResourceManager = FileResourceManager.this;
                    synchronized (fileResourceManager) {
                        ArrayList<ResourceChangeEvent> events = new ArrayList<ResourceChangeEvent>();
                        for (FileChangeEvent change : changes) {
                            if (!change.getFile().getAbsolutePath().startsWith(FileResourceManager.this.base)) continue;
                            String path = change.getFile().getAbsolutePath().substring(FileResourceManager.this.base.length());
                            events.add(new ResourceChangeEvent(path, ResourceChangeEvent.Type.valueOf(change.getType().name())));
                        }
                        for (ResourceChangeListener listener : FileResourceManager.this.listeners) {
                            listener.handleChanges(events);
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void removeResourceChangeListener(ResourceChangeListener listener) {
        this.listeners.remove(listener);
    }

    public long getTransferMinSize() {
        return this.transferMinSize;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileSystemWatcher != null) {
            this.fileSystemWatcher.close();
        }
    }
}

