/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.UndertowLogger;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClientMessages;
import io.undertow.client.ajp.AjpClientExchange;
import io.undertow.client.ajp.AjpClientRequestConduit;
import io.undertow.client.ajp.AjpClientResponseConduit;
import io.undertow.client.ajp.AjpResponseBuilder;
import io.undertow.client.ajp.AjpResponseParseState;
import io.undertow.client.ajp.AjpResponseParser;
import io.undertow.conduits.ConduitListener;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.Headers;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

class AjpClientConnection
extends AbstractAttachable
implements Closeable,
ClientConnection {
    public final ConduitListener<StreamSinkConduit> requestFinishListener = new ConduitListener<StreamSinkConduit>(){

        @Override
        public void handleEvent(StreamSinkConduit channel) {
            AjpClientConnection.this.currentRequest.terminateRequest();
        }
    };
    public final ConduitListener<StreamSourceConduit> responseFinishedListener = new ConduitListener<StreamSourceConduit>(){

        @Override
        public void handleEvent(StreamSourceConduit channel) {
            AjpClientConnection.this.currentRequest.terminateResponse();
        }
    };
    private final Deque<AjpClientExchange> pendingQueue = new ArrayDeque<AjpClientExchange>();
    private AjpClientExchange currentRequest;
    private AjpResponseBuilder pendingResponse;
    private final OptionMap options;
    private final StreamConnection connection;
    private final PushBackStreamSourceConduit pushBackStreamSourceConduit;
    private final Pool<ByteBuffer> bufferPool;
    private final StreamSinkConduit originalSinkConduit;
    private static final int UPGRADED = 0x10000000;
    private static final int UPGRADE_REQUESTED = 0x20000000;
    private static final int CLOSE_REQ = 0x40000000;
    private static final int CLOSED = Integer.MIN_VALUE;
    private int state;
    private final ChannelListener.SimpleSetter<AjpClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final ClientReadListener clientReadListener = new ClientReadListener();

    AjpClientConnection(StreamConnection connection, OptionMap options, Pool<ByteBuffer> bufferPool) {
        this.options = options;
        this.connection = connection;
        this.pushBackStreamSourceConduit = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
        this.connection.getSourceChannel().setConduit(this.pushBackStreamSourceConduit);
        this.bufferPool = bufferPool;
        this.originalSinkConduit = connection.getSinkChannel().getConduit();
        connection.getCloseSetter().set((ChannelListener<? extends StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection channel) {
                ChannelListeners.invokeChannelListener(AjpClientConnection.this, AjpClientConnection.this.closeSetter.get());
            }
        });
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connection.getPeerAddress();
    }

    StreamConnection getConnection() {
        return this.connection;
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.connection.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends AjpClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.connection.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.connection.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.connection.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.connection.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.connection.setOption(option, value);
    }

    @Override
    public boolean isUpgraded() {
        return Bits.anyAreSet(this.state, 0x30000000);
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        if (Bits.anyAreSet(this.state, -268435456)) {
            throw UndertowClientMessages.MESSAGES.invalidConnectionState();
        }
        AjpClientExchange AjpClientExchange2 = new AjpClientExchange(clientCallback, request, this);
        if (this.currentRequest == null) {
            this.inititateRequest(AjpClientExchange2);
        } else {
            this.pendingQueue.add(AjpClientExchange2);
        }
    }

    private void inititateRequest(AjpClientExchange AjpClientExchange2) {
        this.currentRequest = AjpClientExchange2;
        this.pendingResponse = new AjpResponseBuilder();
        ClientRequest request = AjpClientExchange2.getRequest();
        String connectionString = request.getRequestHeaders().getFirst(Headers.CONNECTION);
        if (connectionString != null) {
            if (Headers.CLOSE.equalToString(connectionString)) {
                this.state |= 0x40000000;
            }
        } else if (request.getProtocol() != Protocols.HTTP_1_1) {
            this.state |= 0x40000000;
        }
        if (request.getRequestHeaders().contains(Headers.UPGRADE)) {
            this.state |= 0x20000000;
        }
        ConduitStreamSourceChannel sourceChannel = this.connection.getSourceChannel();
        sourceChannel.setReadListener(this.clientReadListener);
        sourceChannel.resumeReads();
        long length = 0L;
        ConduitStreamSinkChannel sinkChannel = this.connection.getSinkChannel();
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (fixedLengthString != null) {
            length = Long.parseLong(fixedLengthString);
        } else if (transferEncodingString != null) {
            length = -1L;
        }
        AjpClientRequestConduit ajpClientRequestConduit = new AjpClientRequestConduit(this.originalSinkConduit, this.bufferPool, this.currentRequest, this.requestFinishListener, length);
        this.currentRequest.setAjpClientRequestConduit(ajpClientRequestConduit);
        sinkChannel.setConduit(ajpClientRequestConduit);
        AjpClientExchange2.invokeReadReadyCallback(AjpClientExchange2);
        if (length == 0L) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    sinkChannel.setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<ConduitStreamSinkChannel>(){

                        @Override
                        public void handleException(ConduitStreamSinkChannel channel, IOException exception) {
                            AjpClientConnection.this.handleError(exception);
                        }
                    }));
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        } else if (!sinkChannel.isWriteResumed()) {
            try {
                if (!sinkChannel.flush()) {
                    sinkChannel.setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)new ChannelListener<ConduitStreamSinkChannel>(){

                        @Override
                        public void handleEvent(ConduitStreamSinkChannel channel) {
                            try {
                                if (channel.flush()) {
                                    channel.suspendWrites();
                                }
                            }
                            catch (IOException e) {
                                AjpClientConnection.this.handleError(e);
                            }
                        }
                    });
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(IOException exception) {
        this.currentRequest.setFailed(exception);
        IoUtils.safeClose((Closeable)this.connection);
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        if (Bits.allAreSet(this.state, -805306368)) {
            throw new IOException(UndertowClientMessages.MESSAGES.connectionClosed());
        }
        this.state |= 0x10000000;
        return this.connection;
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, Integer.MIN_VALUE)) {
            return;
        }
        this.state |= 0xC0000000;
        this.connection.close();
    }

    public void requestDone() {
        this.connection.getSinkChannel().setConduit(this.originalSinkConduit);
        this.connection.getSourceChannel().setConduit(this.pushBackStreamSourceConduit);
        this.connection.getSinkChannel().suspendWrites();
        this.connection.getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)null);
        if (Bits.anyAreSet(this.state, 0x40000000)) {
            this.currentRequest = null;
            IoUtils.safeClose((Closeable)this.connection);
        } else if (Bits.anyAreSet(this.state, 0x20000000)) {
            this.connection.getSourceChannel().suspendReads();
            this.currentRequest = null;
            return;
        }
        this.currentRequest = null;
        AjpClientExchange next = this.pendingQueue.poll();
        if (next == null) {
            this.connection.getSourceChannel().setReadListener(this.clientReadListener);
            this.connection.getSourceChannel().resumeReads();
        } else {
            this.inititateRequest(next);
        }
    }

    public void requestClose() {
        this.state |= 0x40000000;
    }

    public void installReadBodyListener() {
        this.connection.getSourceChannel().setConduit(this.pushBackStreamSourceConduit);
        this.connection.getSourceChannel().setReadListener(new ResponseRecievedReadListener());
        this.connection.getSourceChannel().resumeReads();
    }

    class ResponseRecievedReadListener
    implements ChannelListener<StreamSourceChannel> {
        private AjpResponseBuilder builder = new AjpResponseBuilder();

        ResponseRecievedReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSourceChannel channel) {
            Pooled pooled = AjpClientConnection.this.bufferPool.allocate();
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.clear();
            boolean free = true;
            try {
                AjpResponseParseState state = this.builder.getParseState();
                do {
                    int res;
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        AjpClientConnection.this.currentRequest.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    buffer.flip();
                    if (res == 0 && !buffer.hasRemaining()) {
                        if (!channel.isReadResumed()) {
                            channel.getReadSetter().set(this);
                            channel.resumeReads();
                        }
                        return;
                    }
                    if (res == -1 && !buffer.hasRemaining()) {
                        try {
                            channel.suspendReads();
                            channel.shutdownReads();
                            IoUtils.safeClose((Closeable)AjpClientConnection.this.connection);
                        }
                        catch (IOException e) {
                            if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                                UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                            }
                            AjpClientConnection.this.currentRequest.setFailed(e);
                            IoUtils.safeClose((Closeable)AjpClientConnection.this.connection);
                            if (free) {
                                pooled.free();
                            }
                            return;
                        }
                        return;
                    }
                    AjpResponseParser.INSTANCE.parse(buffer, state, this.builder);
                    if (state.isComplete()) {
                        if (state.prefix == 6) {
                            AjpClientConnection.this.currentRequest.getAjpClientRequestConduit().setBodyChunkRequested(state.currentIntegerPart);
                            state.reset();
                            buffer.compact();
                            continue;
                        }
                        UndertowLogger.CLIENT_LOGGER.debugf("Received invalid AJP response code %s with no request active, closing connection", (Object)state.prefix);
                        IoUtils.safeClose((Closeable)AjpClientConnection.this.connection);
                        AjpClientConnection.this.currentRequest.setFailed(UndertowClientMessages.MESSAGES.receivedInvalidChunk(state.prefix));
                        continue;
                    }
                    buffer.clear();
                } while (!state.isComplete());
            }
            catch (Exception e) {
                UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(e);
                IoUtils.safeClose((Closeable)AjpClientConnection.this.connection);
            }
            finally {
                if (free) {
                    pooled.free();
                }
            }
        }
    }

    class ClientReadListener
    implements ChannelListener<StreamSourceChannel> {
        ClientReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleEvent(StreamSourceChannel channel) {
            AjpResponseBuilder builder = AjpClientConnection.this.pendingResponse;
            Pooled<ByteBuffer> pooled = AjpClientConnection.this.bufferPool.allocate();
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.clear();
            boolean free = true;
            try {
                String connectionString;
                if (builder == null) {
                    buffer.clear();
                    try {
                        int res = channel.read(buffer);
                        if (res == -1) {
                            UndertowLogger.CLIENT_LOGGER.debugf("Connection to %s was closed by the target server", (Object)AjpClientConnection.this.connection.getPeerAddress());
                            IoUtils.safeClose((Closeable)AjpClientConnection.this);
                            return;
                        }
                        if (res == 0) return;
                        UndertowLogger.CLIENT_LOGGER.debugf("Target server %s sent unexpected data when no request pending, closing connection", (Object)AjpClientConnection.this.connection.getPeerAddress());
                        IoUtils.safeClose((Closeable)AjpClientConnection.this);
                        return;
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)AjpClientConnection.this.connection);
                    }
                    return;
                }
                AjpResponseParseState state = builder.getParseState();
                do {
                    int res;
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        AjpClientConnection.this.currentRequest.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                        if (!free) return;
                        pooled.free();
                        return;
                    }
                    buffer.flip();
                    if (res == 0 && !buffer.hasRemaining()) {
                        if (channel.isReadResumed()) return;
                        channel.getReadSetter().set(this);
                        channel.resumeReads();
                        return;
                    }
                    if (res == -1 && !buffer.hasRemaining()) {
                        channel.suspendReads();
                        IoUtils.safeClose((Closeable)AjpClientConnection.this);
                        try {
                            ConduitStreamSinkChannel requestChannel = AjpClientConnection.this.connection.getSinkChannel();
                            requestChannel.shutdownWrites();
                            if (!requestChannel.flush()) {
                                requestChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                                requestChannel.resumeWrites();
                            }
                            AjpClientConnection.this.currentRequest.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                            return;
                        }
                        catch (IOException e) {
                            if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                                UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                            }
                            AjpClientConnection.this.currentRequest.setFailed(e);
                            IoUtils.safeClose((Closeable)channel);
                            if (!free) return;
                            pooled.free();
                            return;
                        }
                    }
                    AjpResponseParser.INSTANCE.parse(buffer, state, builder);
                    if (state.isComplete()) {
                        if (state.prefix == 6) {
                            AjpClientConnection.this.currentRequest.getAjpClientRequestConduit().setBodyChunkRequested(state.currentIntegerPart);
                            state.reset();
                            buffer.compact();
                            continue;
                        }
                        if (!buffer.hasRemaining()) continue;
                        free = false;
                        AjpClientConnection.this.pushBackStreamSourceConduit.pushBack(pooled);
                        continue;
                    }
                    buffer.clear();
                } while (!state.isComplete());
                ClientResponse response = builder.build();
                if (Bits.anyAreSet(AjpClientConnection.this.state, 0x20000000) && ((connectionString = response.getResponseHeaders().getFirst(Headers.CONNECTION)) == null || !Headers.UPGRADE.equalToString(connectionString))) {
                    AjpClientConnection.this.state &= -536870913;
                }
                if (builder.getStatusCode() == 100) {
                    AjpClientConnection.this.pendingResponse = new AjpResponseBuilder();
                    AjpClientConnection.this.currentRequest.setContinueResponse(response);
                    return;
                } else {
                    AjpClientConnection.this.connection.getSourceChannel().setConduit(new AjpClientResponseConduit(AjpClientConnection.this.connection.getSourceChannel().getConduit(), AjpClientConnection.this, AjpClientConnection.this.currentRequest.getAjpClientRequestConduit(), AjpClientConnection.this.responseFinishedListener));
                    channel.getReadSetter().set(null);
                    channel.suspendReads();
                    AjpClientConnection.this.pendingResponse = null;
                    AjpClientConnection.this.currentRequest.setResponse(response);
                }
                return;
            }
            catch (Exception e) {
                UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(e);
                IoUtils.safeClose((Closeable)AjpClientConnection.this.connection);
                return;
            }
            finally {
                if (free) {
                    pooled.free();
                }
            }
        }
    }
}

