/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.AttachmentKey;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class PipeliningBufferingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static final AttachmentKey<PipeliningBufferingStreamSinkConduit> ATTACHMENT_KEY = AttachmentKey.create(PipeliningBufferingStreamSinkConduit.class);
    private static final int SHUTDOWN = 1;
    private static final int DELEGATE_SHUTDOWN = 2;
    private static final int FLUSHING = 8;
    private int state;
    private final Pool<ByteBuffer> pool;
    private Pooled<ByteBuffer> buffer;
    private final ExchangeCompletionListener completionListener = new PipelineExchangeCompletionListener();

    public PipeliningBufferingStreamSinkConduit(StreamSinkConduit next, Pool<ByteBuffer> pool) {
        super(next);
        this.pool = pool;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        boolean res;
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet(this.state, 8) && !(res = this.flushBuffer())) {
            return 0L;
        }
        Pooled<ByteBuffer> pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        ByteBuffer buffer = pooled.getResource();
        int total = 0;
        for (int i = offset; i < offset + length; ++i) {
            total += srcs[i].remaining();
        }
        if (buffer.remaining() > total) {
            int put = total;
            Buffers.copy(buffer, srcs, offset, length);
            return put;
        }
        return this.flushBufferWithUserData(srcs);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer;
        boolean res;
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet(this.state, 8) && !(res = this.flushBuffer())) {
            return 0;
        }
        Pooled<ByteBuffer> pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        if ((buffer = pooled.getResource()).remaining() > src.remaining()) {
            int put = src.remaining();
            buffer.put(src);
            return put;
        }
        return (int)this.flushBufferWithUserData(new ByteBuffer[]{src});
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long flushBufferWithUserData(ByteBuffer[] byteBuffers) throws IOException {
        ByteBuffer byteBuffer = this.buffer.getResource();
        if (byteBuffer.position() == 0) {
            try {
                long l = ((StreamSinkConduit)this.next).write(byteBuffers, 0, byteBuffers.length);
                return l;
            }
            finally {
                this.buffer.free();
                this.buffer = null;
            }
        }
        if (!Bits.anyAreSet(this.state, 8)) {
            this.state |= 8;
            byteBuffer.flip();
        }
        int originalBufferedRemaining = byteBuffer.remaining();
        long toWrite = originalBufferedRemaining;
        ByteBuffer[] writeBufs = new ByteBuffer[byteBuffers.length + 1];
        writeBufs[0] = byteBuffer;
        for (int i = 0; i < byteBuffers.length; ++i) {
            writeBufs[i + 1] = byteBuffers[i];
            toWrite += (long)byteBuffers[i].remaining();
        }
        long res = 0L;
        long written = 0L;
        do {
            res = ((StreamSinkConduit)this.next).write(writeBufs, 0, writeBufs.length);
            written += res;
            if (res != 0L) continue;
            if (written > (long)originalBufferedRemaining) {
                this.buffer.free();
                this.buffer = null;
                this.state &= 0xFFFFFFF7;
                return written - (long)originalBufferedRemaining;
            }
            return 0L;
        } while (written < toWrite);
        this.buffer.free();
        this.buffer = null;
        this.state &= 0xFFFFFFF7;
        return written - (long)originalBufferedRemaining;
    }

    public boolean flushPipelinedData() throws IOException {
        if (this.buffer == null || this.buffer.getResource().position() == 0 && Bits.allAreClear(this.state, 8)) {
            return ((StreamSinkConduit)this.next).flush();
        }
        return this.flushBuffer();
    }

    public void setupPipelineBuffer(HttpServerExchange exchange) {
        exchange.addExchangeCompleteListener(this.completionListener);
        ((HttpServerConnection)exchange.getConnection()).getChannel().getSinkChannel().setConduit(this);
    }

    private boolean flushBuffer() throws IOException {
        if (this.buffer == null) {
            return ((StreamSinkConduit)this.next).flush();
        }
        ByteBuffer byteBuffer = this.buffer.getResource();
        if (!Bits.anyAreSet(this.state, 8)) {
            this.state |= 8;
            byteBuffer.flip();
        }
        while (byteBuffer.hasRemaining()) {
            if (((StreamSinkConduit)this.next).write(byteBuffer) != 0) continue;
            return false;
        }
        if (!((StreamSinkConduit)this.next).flush()) {
            return false;
        }
        this.buffer.free();
        this.buffer = null;
        this.state &= 0xFFFFFFF7;
        return true;
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.buffer != null && this.buffer.getResource().hasRemaining()) {
            return;
        }
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.buffer != null) {
            if (this.buffer.getResource().hasRemaining()) {
                return;
            }
            ((StreamSinkConduit)this.next).awaitWritable();
        }
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            if (!this.flushBuffer()) {
                return false;
            }
            if (Bits.anyAreSet(this.state, 1) && Bits.anyAreClear(this.state, 2)) {
                this.state |= 2;
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            return ((StreamSinkConduit)this.next).flush();
        }
        return true;
    }

    @Override
    public void terminateWrites() throws IOException {
        this.state |= 1;
        if (this.buffer == null) {
            this.state |= 2;
            ((StreamSinkConduit)this.next).terminateWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateWrites() throws IOException {
        try {
            ((StreamSinkConduit)this.next).truncateWrites();
        }
        finally {
            if (this.buffer != null) {
                this.buffer.free();
            }
        }
    }

    private class PipelineExchangeCompletionListener
    implements ExchangeCompletionListener {
        private PipelineExchangeCompletionListener() {
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            HttpServerConnection connection = (HttpServerConnection)exchange.getConnection();
            if (connection.getExtraBytes() == null || exchange.isUpgrade()) {
                this.performFlush(nextListener, connection);
            } else {
                nextListener.proceed();
            }
        }

        private void performFlush(final ExchangeCompletionListener.NextListener nextListener, final HttpServerConnection connection) {
            try {
                final AbstractServerConnection.ConduitState oldState = connection.resetChannel();
                if (!PipeliningBufferingStreamSinkConduit.this.flushPipelinedData()) {
                    final StreamConnection channel = connection.getChannel();
                    channel.getSinkChannel().getWriteSetter().set((ChannelListener<ConduitStreamSinkChannel>)new ChannelListener<Channel>(){

                        @Override
                        public void handleEvent(Channel c) {
                            try {
                                if (PipeliningBufferingStreamSinkConduit.this.flushPipelinedData()) {
                                    channel.getSinkChannel().getWriteSetter().set(null);
                                    channel.getSinkChannel().suspendWrites();
                                    connection.restoreChannel(oldState);
                                    nextListener.proceed();
                                }
                            }
                            catch (IOException e) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                IoUtils.safeClose((Closeable)channel);
                            }
                        }
                    });
                    connection.getChannel().getSinkChannel().resumeWrites();
                    return;
                }
                connection.restoreChannel(oldState);
                nextListener.proceed();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)connection.getChannel());
            }
        }
    }
}

