/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.ConnectionSSLSessionInfo;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.server.protocol.http.HttpTransferEncoding;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.SslChannel;

public final class HttpServerConnection
extends AbstractServerConnection {
    private SSLSessionInfo sslSessionInfo;

    public HttpServerConnection(StreamConnection channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        super(channel, bufferPool, rootHandler, undertowOptions, bufferSize);
        if (channel instanceof SslChannel) {
            this.sslSessionInfo = new ConnectionSSLSessionInfo((SslChannel)((Object)channel), this);
        }
    }

    @Override
    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        if (exchange == null || !HttpContinue.requiresContinueResponse(exchange)) {
            throw UndertowMessages.MESSAGES.outOfBandResponseOnlyAllowedFor100Continue();
        }
        final AbstractServerConnection.ConduitState state = this.resetChannel();
        HttpServerExchange newExchange = new HttpServerExchange(this);
        for (HttpString header : exchange.getRequestHeaders().getHeaderNames()) {
            newExchange.getRequestHeaders().putAll(header, exchange.getRequestHeaders().get(header));
        }
        newExchange.setProtocol(exchange.getProtocol());
        newExchange.setRequestMethod(exchange.getRequestMethod());
        exchange.setRequestURI(exchange.getRequestURI(), exchange.isHostIncludedInRequestURI());
        exchange.setRequestPath(exchange.getRequestPath());
        exchange.setRelativePath(exchange.getRelativePath());
        newExchange.getRequestHeaders().put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
        newExchange.getRequestHeaders().put(Headers.CONTENT_LENGTH, 0L);
        HttpTransferEncoding.setupRequest(newExchange);
        this.channel.getSourceChannel().setConduit(HttpServerConnection.source(state));
        newExchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                HttpServerConnection.this.restoreChannel(state);
            }
        });
        return newExchange;
    }

    public void ungetRequestBytes(Pooled<ByteBuffer> unget) {
        if (this.getExtraBytes() == null) {
            this.setExtraBytes(unget);
        } else {
            Pooled<ByteBuffer> eb = this.getExtraBytes();
            ByteBuffer buf = eb.getResource();
            ByteBuffer ugBuffer = unget.getResource();
            if (ugBuffer.limit() - ugBuffer.remaining() > buf.remaining()) {
                ugBuffer.compact();
                ugBuffer.put(buf);
                ugBuffer.flip();
                eb.free();
                this.setExtraBytes(unget);
            } else {
                byte[] data = new byte[ugBuffer.remaining() + buf.remaining()];
                int first = ugBuffer.remaining();
                ugBuffer.get(data, 0, ugBuffer.remaining());
                buf.get(data, first, buf.remaining());
                eb.free();
                unget.free();
                final ByteBuffer newBuffer = ByteBuffer.wrap(data);
                this.setExtraBytes(new Pooled<ByteBuffer>(){

                    @Override
                    public void discard() {
                    }

                    @Override
                    public void free() {
                    }

                    @Override
                    public ByteBuffer getResource() throws IllegalStateException {
                        return newBuffer;
                    }
                });
            }
        }
    }

    @Override
    public SSLSessionInfo getSslSessionInfo() {
        return this.sslSessionInfo;
    }

    @Override
    public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
        this.sslSessionInfo = sessionInfo;
    }

    public SSLSession getSslSession() {
        if (this.channel instanceof SslChannel) {
            return ((SslChannel)((Object)this.channel)).getSslSession();
        }
        return null;
    }

    @Override
    protected StreamConnection upgradeChannel() {
        this.resetChannel();
        if (this.extraBytes != null) {
            this.channel.getSourceChannel().setConduit(new ReadDataStreamSourceConduit(this.channel.getSourceChannel().getConduit(), this));
        }
        return this.channel;
    }

    @Override
    protected boolean isUpgradeSupported() {
        return true;
    }
}

