/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class SessionRestoringHandler
implements HttpHandler,
Lifecycle {
    private final String deploymentName;
    private final Map<String, Map<String, Object>> data;
    private final SessionManager sessionManager;
    private final ServletContextImpl servletContext;
    private final HttpHandler next;
    private final Set<String> sessionIds;
    private final SessionIdListener sessionListener;
    private final SessionPersistenceManager sessionPersistenceManager;
    private volatile boolean started = false;

    public SessionRestoringHandler(String deploymentName, SessionManager sessionManager, ServletContextImpl servletContext, HttpHandler next, SessionPersistenceManager sessionPersistenceManager) {
        this.deploymentName = deploymentName;
        this.sessionManager = sessionManager;
        this.servletContext = servletContext;
        this.next = next;
        this.sessionPersistenceManager = sessionPersistenceManager;
        this.data = new ConcurrentHashMap<String, Map<String, Object>>();
        this.sessionIds = new ConcurrentSkipListSet<String>();
        this.sessionListener = new SessionIdListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        ClassLoader old = this.getTccl();
        try {
            this.setTccl(this.servletContext.getClassLoader());
            this.sessionManager.registerSessionListener(this.sessionListener);
            try {
                Map<String, Map<String, Object>> sessionData = this.sessionPersistenceManager.loadSessionAttributes(this.deploymentName, this.servletContext.getClassLoader());
                if (sessionData != null) {
                    this.data.putAll(sessionData);
                }
            }
            catch (Exception e) {
                UndertowServletLogger.ROOT_LOGGER.failedtoLoadPersistentSessions(e);
            }
            this.started = true;
        }
        finally {
            this.setTccl(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ClassLoader old = this.getTccl();
        try {
            this.setTccl(this.servletContext.getClassLoader());
            this.started = false;
            HashMap<String, Map<String, Object>> objectData = new HashMap<String, Map<String, Object>>();
            for (String sessionId : this.sessionIds) {
                try {
                    Session session = this.sessionManager.getSession(sessionId);
                    if (session == null) continue;
                    HashMap<String, Object> sessionData = new HashMap<String, Object>();
                    for (String attr : session.getAttributeNames()) {
                        sessionData.put(attr, session.getAttribute(attr));
                    }
                    objectData.put(sessionId, sessionData);
                }
                catch (Exception e) {
                    UndertowServletLogger.ROOT_LOGGER.failedToPersistSession(sessionId, e);
                }
            }
            this.sessionPersistenceManager.persistSessions(this.deploymentName, objectData);
            this.sessionManager.removeSessionListener(this.sessionListener);
            this.data.clear();
            this.sessionIds.clear();
        }
        finally {
            this.setTccl(old);
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String incomingSessionId = this.servletContext.getSessionConfig().findSessionId(exchange);
        if (incomingSessionId == null || this.sessionIds.contains(incomingSessionId)) {
            this.next.handleRequest(exchange);
            return;
        }
        Map<String, Object> result = this.data.remove(incomingSessionId);
        if (result != null) {
            HttpSessionImpl session = this.servletContext.getSession(exchange, true);
            for (Map.Entry<String, Object> entry : result.entrySet()) {
                session.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        this.next.handleRequest(exchange);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void setTccl(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    class SessionIdListener
    implements SessionListener {
        SessionIdListener() {
        }

        @Override
        public void sessionCreated(Session session, HttpServerExchange exchange) {
            SessionRestoringHandler.this.sessionIds.add(session.getId());
        }

        @Override
        public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
            SessionRestoringHandler.this.sessionIds.remove(session.getId());
        }

        @Override
        public void attributeAdded(Session session, String name, Object value) {
        }

        @Override
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        }

        @Override
        public void attributeRemoved(Session session, String name, Object oldValue) {
        }

        @Override
        public void sessionIdChanged(Session session, String oldSessionId) {
            SessionRestoringHandler.this.sessionIds.add(session.getId());
            SessionRestoringHandler.this.sessionIds.remove(oldSessionId);
        }
    }
}

