/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.ajp.AjpServerRequestConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.ExchangeCookieUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.StatusCodes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

final class AjpServerResponseConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final Logger log = Logger.getLogger("io.undertow.server.channel.ajp.response");
    private static final int MAX_DATA_SIZE = 8184;
    private static final Map<HttpString, Integer> HEADER_MAP;
    private static final int FLAG_START = 1;
    private static final int FLAG_SHUTDOWN = 4;
    private static final int FLAG_DELEGATE_SHUTDOWN = 8;
    private static final int FLAG_CLOSE_QUEUED = 16;
    private static final int FLAG_WRITE_RESUMED = 32;
    private static final int FLAG_WRITE_READ_BODY_CHUNK_FROM_LISTENER = 64;
    private final Pool<ByteBuffer> pool;
    private int state = 1;
    private Pooled<ByteBuffer> currentDataBuffer;
    private ByteBuffer[] packetHeaderAndDataBuffer;
    private final HttpServerExchange exchange;
    private final ConduitListener<? super AjpServerResponseConduit> finishListener;
    private final boolean headRequest;
    private ByteBuffer readBodyChunkBuffer;

    AjpServerResponseConduit(StreamSinkConduit next, Pool<ByteBuffer> pool, HttpServerExchange exchange, ConduitListener<? super AjpServerResponseConduit> finishListener, boolean headRequest) {
        super(next);
        this.pool = pool;
        this.exchange = exchange;
        this.finishListener = finishListener;
        this.headRequest = headRequest;
        this.state = 1;
    }

    private void putInt(ByteBuffer buf, int value) {
        buf.put((byte)(value >> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
    }

    private void putString(ByteBuffer buf, String value) {
        int length = value.length();
        this.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put((byte)value.charAt(i));
        }
        buf.put((byte)0);
    }

    private boolean processWrite() throws IOException {
        if (Bits.anyAreSet(this.state, 8)) {
            return true;
        }
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 1)) {
            if (this.readBodyChunkBuffer == null) {
                ExchangeCookieUtils.flattenCookies(this.exchange);
                this.currentDataBuffer = this.pool.allocate();
                ByteBuffer buffer = this.currentDataBuffer.getResource();
                this.packetHeaderAndDataBuffer = new ByteBuffer[1];
                this.packetHeaderAndDataBuffer[0] = buffer;
                buffer.put((byte)65);
                buffer.put((byte)66);
                buffer.put((byte)0);
                buffer.put((byte)0);
                buffer.put((byte)4);
                this.putInt(buffer, this.exchange.getResponseCode());
                this.putString(buffer, StatusCodes.getReason(this.exchange.getResponseCode()));
                int headers = 0;
                HeaderMap responseHeaders = this.exchange.getResponseHeaders();
                for (HttpString name : responseHeaders.getHeaderNames()) {
                    headers += responseHeaders.get(name).size();
                }
                this.putInt(buffer, headers);
                for (HttpString header : responseHeaders.getHeaderNames()) {
                    for (String headerValue : responseHeaders.get(header)) {
                        Integer headerCode = HEADER_MAP.get(header);
                        if (headerCode != null) {
                            this.putInt(buffer, headerCode);
                        } else {
                            this.putString(buffer, header.toString());
                        }
                        this.putString(buffer, headerValue);
                    }
                }
                int dataLength = buffer.position() - 4;
                buffer.put(2, (byte)(dataLength >> 8 & 0xFF));
                buffer.put(3, (byte)(dataLength & 0xFF));
                buffer.flip();
                this.state &= 0xFFFFFFFE;
            } else {
                ByteBuffer readBuffer = this.readBodyChunkBuffer;
                do {
                    int res;
                    if ((res = ((StreamSinkConduit)this.next).write(readBuffer)) != 0) continue;
                    return false;
                } while (this.readBodyChunkBuffer.hasRemaining());
                this.readBodyChunkBuffer = null;
                this.state &= 0xFFFFFFBF;
                return true;
            }
        }
        if (this.currentDataBuffer != null && !this.writeCurrentBuffer()) {
            return false;
        }
        ByteBuffer readBuffer = this.readBodyChunkBuffer;
        if (readBuffer != null) {
            do {
                int res;
                if ((res = ((StreamSinkConduit)this.next).write(readBuffer)) != 0) continue;
                return false;
            } while (this.readBodyChunkBuffer.hasRemaining());
            this.readBodyChunkBuffer = null;
            this.state &= 0xFFFFFFBF;
        }
        if (Bits.anyAreSet(this.state, 4) && Bits.allAreClear(this.state, 16)) {
            this.state |= 0x10;
            this.currentDataBuffer = this.pool.allocate();
            ByteBuffer buffer = this.currentDataBuffer.getResource();
            this.packetHeaderAndDataBuffer = new ByteBuffer[1];
            this.packetHeaderAndDataBuffer[0] = buffer;
            buffer.put((byte)65);
            buffer.put((byte)66);
            buffer.put((byte)0);
            buffer.put((byte)2);
            buffer.put((byte)5);
            buffer.put((byte)(this.exchange.isPersistent() ? 1 : 0));
            buffer.flip();
            if (!this.writeCurrentBuffer()) {
                return false;
            }
        }
        return true;
    }

    private boolean writeCurrentBuffer() throws IOException {
        long toWrite = 0L;
        for (ByteBuffer b : this.packetHeaderAndDataBuffer) {
            toWrite += (long)b.remaining();
        }
        long r = 0L;
        do {
            if ((r = ((StreamSinkConduit)this.next).write(this.packetHeaderAndDataBuffer, 0, this.packetHeaderAndDataBuffer.length)) == -1L) {
                throw new ClosedChannelException();
            }
            if (r != 0L) continue;
            return false;
        } while ((toWrite -= r) > 0L);
        this.currentDataBuffer.free();
        this.currentDataBuffer = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.processWrite()) {
            return 0;
        }
        if (this.headRequest) {
            int remaining = src.remaining();
            src.position(src.position() + remaining);
            return remaining;
        }
        int limit = src.limit();
        try {
            if (src.remaining() > 8184) {
                src.limit(src.position() + 8184);
            }
            int writeSize = src.remaining();
            ByteBuffer[] buffers = this.createHeader(src);
            int toWrite = 0;
            for (ByteBuffer buffer : buffers) {
                toWrite += buffer.remaining();
            }
            int originalPayloadSize = writeSize;
            int total = 0;
            long r = 0L;
            do {
                r = ((StreamSinkConduit)this.next).write(buffers, 0, buffers.length);
                total = (int)((long)total + r);
                toWrite = (int)((long)toWrite - r);
                if (r == -1L) {
                    throw new ClosedChannelException();
                }
                if (r != 0L) continue;
                Pooled<ByteBuffer> newPooledBuffer = this.pool.allocate();
                while (src.hasRemaining()) {
                    newPooledBuffer.getResource().put(src);
                }
                newPooledBuffer.getResource().flip();
                ByteBuffer[] savedBuffers = new ByteBuffer[]{buffers[0], newPooledBuffer.getResource(), buffers[2]};
                this.packetHeaderAndDataBuffer = savedBuffers;
                this.currentDataBuffer = newPooledBuffer;
                int n = originalPayloadSize;
                return n;
            } while (toWrite > 0);
            int n = originalPayloadSize;
            return n;
        }
        finally {
            src.limit(limit);
        }
    }

    private ByteBuffer[] createHeader(ByteBuffer src) {
        int remaining = src.remaining();
        int chunkSize = remaining + 4;
        byte[] header = new byte[]{65, 66, (byte)(chunkSize >> 8 & 0xFF), (byte)(chunkSize & 0xFF), 3, (byte)(remaining >> 8 & 0xFF), (byte)(remaining & 0xFF)};
        byte[] footer = new byte[]{0};
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(header), src, ByteBuffer.wrap(footer)};
        return buffers;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            while (srcs[i].hasRemaining()) {
                int written = this.write(srcs[i]);
                if (written <= 0 && total == 0L) {
                    return written;
                }
                if (written <= 0) {
                    return total;
                }
                total += (long)written;
            }
        }
        return total;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public boolean flush() throws IOException {
        if (!this.processWrite()) {
            return false;
        }
        int state = this.state;
        if (Bits.allAreSet(state, 4) && Bits.allAreClear(state, 8)) {
            if (!this.exchange.isPersistent()) {
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            if (this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
            this.state |= 8;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        ((StreamSinkConduit)this.next).setWriteReadyHandler(new AjpServerWriteReadyHandler(handler));
    }

    @Override
    public void suspendWrites() {
        log.trace("suspend");
        this.state &= 0xFFFFFFDF;
        if (Bits.allAreClear(this.state, 64)) {
            ((StreamSinkConduit)this.next).suspendWrites();
        }
    }

    @Override
    public void resumeWrites() {
        log.trace("resume");
        this.state |= 0x20;
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.anyAreSet(this.state, 32);
    }

    @Override
    public void wakeupWrites() {
        log.trace("wakeup");
        this.state |= 0x20;
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    @Override
    public void terminateWrites() throws IOException {
        if (Bits.anyAreSet(this.state, 4)) {
            return;
        }
        this.state |= 4;
        if (Bits.allAreClear(this.state, 1) && this.readBodyChunkBuffer == null && this.packetHeaderAndDataBuffer == null) {
            if (!this.exchange.isPersistent()) {
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            if (this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
            this.state |= 8;
        }
    }

    public boolean doGetRequestBodyChunk(ByteBuffer buffer, AjpServerRequestConduit requestChannel) throws IOException {
        this.readBodyChunkBuffer = buffer;
        boolean result = this.processWrite();
        if (!result) {
            this.state |= 0x40;
            ((StreamSinkConduit)this.next).resumeWrites();
        }
        return result;
    }

    static {
        HashMap<HttpString, Integer> headers = new HashMap<HttpString, Integer>();
        headers.put(Headers.CONTENT_TYPE, 40961);
        headers.put(Headers.CONTENT_LANGUAGE, 40962);
        headers.put(Headers.CONTENT_LENGTH, 40963);
        headers.put(Headers.DATE, 40964);
        headers.put(Headers.LAST_MODIFIED, 40965);
        headers.put(Headers.LOCATION, 40966);
        headers.put(Headers.SET_COOKIE, 40967);
        headers.put(Headers.SET_COOKIE2, 40968);
        headers.put(Headers.SERVLET_ENGINE, 40969);
        headers.put(Headers.STATUS, 40970);
        headers.put(Headers.WWW_AUTHENTICATE, 40971);
        HEADER_MAP = Collections.unmodifiableMap(headers);
    }

    private final class AjpServerWriteReadyHandler
    implements WriteReadyHandler {
        private final WriteReadyHandler delegate;

        private AjpServerWriteReadyHandler(WriteReadyHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void writeReady() {
            if (Bits.anyAreSet(AjpServerResponseConduit.this.state, 64)) {
                try {
                    boolean result = AjpServerResponseConduit.this.processWrite();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (Bits.anyAreSet(AjpServerResponseConduit.this.state, 32)) {
                this.delegate.writeReady();
            } else {
                AjpServerResponseConduit.this.suspendWrites();
            }
        }

        @Override
        public void forceTermination() {
            this.delegate.forceTermination();
        }

        @Override
        public void terminated() {
            this.delegate.terminated();
        }
    }
}

