/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedFilters;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.ManagedServlets;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.FilterHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatchesData;
import io.undertow.servlet.handlers.security.ServletSecurityRoleHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;

public class ServletPathMatches {
    public static final String DEFAULT_SERVLET_NAME = "default";
    private final Deployment deployment;
    private volatile ServletPathMatchesData data;

    public ServletPathMatches(Deployment deployment) {
        this.deployment = deployment;
    }

    public ServletChain getServletHandlerByName(String name) {
        return this.getData().getServletHandlerByName(name);
    }

    public ServletPathMatch getServletHandlerByExactPath(String path) {
        return this.getData().getServletHandlerByExactPath(path);
    }

    public ServletPathMatch getServletHandlerByPath(String path) {
        return this.getData().getServletHandlerByPath(path);
    }

    public void invalidate() {
        this.data = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletPathMatchesData getData() {
        ServletPathMatchesData data = this.data;
        if (data != null) {
            return data;
        }
        ServletPathMatches servletPathMatches = this;
        synchronized (servletPathMatches) {
            if (this.data != null) {
                return this.data;
            }
            this.data = this.setupServletChains();
            return this.data;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ServletPathMatchesData setupServletChains() {
        ServletChain defaultHandler = null;
        ServletHandler defaultServlet = null;
        ManagedServlets servlets = this.deployment.getServlets();
        ManagedFilters filters = this.deployment.getFilters();
        HashMap<String, ServletHandler> extensionServlets = new HashMap<String, ServletHandler>();
        HashMap<String, ServletHandler> pathServlets = new HashMap<String, ServletHandler>();
        HashSet<Object> pathMatches = new HashSet<Object>();
        HashSet<String> extensionMatches = new HashSet<String>();
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
            if (filterMappingInfo.getMappingType() != FilterMappingInfo.MappingType.URL) continue;
            String path = filterMappingInfo.getMapping();
            if (path.equals("*")) {
                path = "/*";
            }
            if (!path.startsWith("*.")) {
                pathMatches.add(path);
                continue;
            }
            extensionMatches.add(path.substring(2));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            ServletHandler handler = (ServletHandler)entry.getValue();
            for (String string : handler.getManagedServlet().getServletInfo().getMappings()) {
                if (string.equals("/")) {
                    pathMatches.add("/*");
                    if (pathServlets.containsKey("/*") || defaultServlet != null) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(string);
                    }
                    defaultServlet = handler;
                    defaultHandler = ServletPathMatches.servletChain(handler, handler.getManagedServlet(), null, deploymentInfo);
                    continue;
                }
                if (!string.startsWith("*.")) {
                    void var14_17;
                    if (string.isEmpty()) {
                        String string2 = "/";
                    }
                    pathMatches.add(var14_17);
                    if (pathServlets.containsKey(var14_17)) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping((String)var14_17);
                    }
                    pathServlets.put((String)var14_17, handler);
                    continue;
                }
                String ext = string.substring(2);
                extensionMatches.add(ext);
                extensionServlets.put(ext, handler);
            }
        }
        DefaultServletConfig config = deploymentInfo.getDefaultServletConfig() == null ? new DefaultServletConfig() : deploymentInfo.getDefaultServletConfig();
        ServletHandler servletHandler = servlets.addServlet(new ServletInfo(DEFAULT_SERVLET_NAME, DefaultServlet.class));
        if (defaultServlet == null) {
            pathMatches.add("/*");
            defaultServlet = servletHandler;
            defaultHandler = new ServletChain(defaultServlet, servletHandler.getManagedServlet(), null);
        }
        ServletPathMatchesData.Builder builder = ServletPathMatchesData.builder();
        for (String string : pathMatches) {
            MatchData targetServletMatch = ServletPathMatches.resolveServletForPath(string, pathServlets);
            HashMap<DispatcherType, List<ManagedFilter>> noExtension = new HashMap<DispatcherType, List<ManagedFilter>>();
            HashMap extension = new HashMap();
            for (String ext : extensionMatches) {
                extension.put(ext, new HashMap());
            }
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() == FilterMappingInfo.MappingType.SERVLET) {
                    if (targetServletMatch.handler == null || !filterMapping.getMapping().equals(targetServletMatch.handler.getManagedServlet().getServletInfo().getName())) continue;
                    ServletPathMatches.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        ServletPathMatches.addToListMap(l, filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                if (filterMapping.getMapping().isEmpty() || !filterMapping.getMapping().startsWith("*.")) {
                    if (!ServletPathMatches.isFilterApplicable(string, filterMapping.getMapping())) continue;
                    ServletPathMatches.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        ServletPathMatches.addToListMap(l, filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                ServletPathMatches.addToListMap((Map)extension.get(filterMapping.getMapping().substring(2)), filterMapping.getDispatcher(), filter);
            }
            if (string.endsWith("/*")) {
                String prefix = string.substring(0, string.length() - 2);
                builder.addPrefixMatch(prefix, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
                for (Map.Entry entry : extension.entrySet()) {
                    ServletHandler pathServlet = targetServletMatch.handler;
                    String pathMatch = targetServletMatch.matchedPath;
                    if (pathServlet == null) {
                        pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                    }
                    if (pathServlet == null) {
                        pathServlet = defaultServlet;
                    }
                    HttpHandler handler = pathServlet;
                    if (!((Map)entry.getValue()).isEmpty()) {
                        handler = new FilterHandler((Map)entry.getValue(), deploymentInfo.isAllowNonStandardWrappers(), handler);
                    }
                    builder.addExtensionMatch(prefix, (String)entry.getKey(), ServletPathMatches.servletChain(handler, pathServlet.getManagedServlet(), pathMatch, deploymentInfo));
                }
                continue;
            }
            if (string.isEmpty()) {
                builder.addExactMatch("/", this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
                continue;
            }
            String lastSegment = string.substring(string.lastIndexOf(47));
            if (lastSegment.contains(".")) {
                String ext;
                ext = lastSegment.substring(lastSegment.lastIndexOf(46) + 1);
                if (extension.containsKey(ext)) {
                    Map extMap = (Map)extension.get(ext);
                    builder.addExactMatch(string, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, extMap, targetServletMatch.matchedPath));
                    continue;
                }
                builder.addExactMatch(string, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
                continue;
            }
            builder.addExactMatch(string, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            HashMap<DispatcherType, List<ManagedFilter>> filtersByDispatcher = new HashMap<DispatcherType, List<ManagedFilter>>();
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !filterMapping.getMapping().equals(entry.getKey())) continue;
                ServletPathMatches.addToListMap(filtersByDispatcher, filterMapping.getDispatcher(), filter);
            }
            if (filtersByDispatcher.isEmpty()) {
                builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain((HttpHandler)entry.getValue(), ((ServletHandler)entry.getValue()).getManagedServlet(), null, deploymentInfo));
                continue;
            }
            builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain(new FilterHandler(filtersByDispatcher, deploymentInfo.isAllowNonStandardWrappers(), (HttpHandler)entry.getValue()), ((ServletHandler)entry.getValue()).getManagedServlet(), null, deploymentInfo));
        }
        builder.setDefaultServlet(defaultHandler);
        return builder.build();
    }

    private ServletChain createHandler(ServletChain defaultHandler, ServletHandler defaultServlet, DeploymentInfo deploymentInfo, ServletHandler targetServlet, Map<DispatcherType, List<ManagedFilter>> noExtension, String servletPath) {
        ServletChain initialHandler;
        if (noExtension.isEmpty()) {
            initialHandler = targetServlet != null ? ServletPathMatches.servletChain(targetServlet, targetServlet.getManagedServlet(), servletPath, deploymentInfo) : defaultHandler;
        } else if (targetServlet != null) {
            FilterHandler handler = new FilterHandler(noExtension, deploymentInfo.isAllowNonStandardWrappers(), targetServlet);
            initialHandler = ServletPathMatches.servletChain(handler, targetServlet.getManagedServlet(), servletPath, deploymentInfo);
        } else {
            FilterHandler handler = new FilterHandler(noExtension, deploymentInfo.isAllowNonStandardWrappers(), defaultServlet);
            initialHandler = ServletPathMatches.servletChain(handler, defaultServlet.getManagedServlet(), servletPath, deploymentInfo);
        }
        return initialHandler;
    }

    private static MatchData resolveServletForPath(String path, Map<String, ServletHandler> pathServlets) {
        if (pathServlets.containsKey(path)) {
            if (path.endsWith("/*")) {
                String base = path.substring(0, path.length() - 2);
                return new MatchData(pathServlets.get(path), base);
            }
            return new MatchData(pathServlets.get(path), path);
        }
        String match = null;
        ServletHandler servlet = null;
        for (Map.Entry<String, ServletHandler> entry : pathServlets.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("/*")) continue;
            String base = key.substring(0, key.length() - 2);
            if (match != null && base.length() <= match.length() || !path.startsWith(base)) continue;
            match = base;
            servlet = entry.getValue();
        }
        if (servlet != null) {
            return new MatchData(servlet, match);
        }
        return new MatchData(null, null);
    }

    private static boolean isFilterApplicable(String path, String filterPath) {
        String modifiedPath = filterPath.equals("*") ? "/*" : filterPath;
        if (path.isEmpty()) {
            return modifiedPath.equals("/*") || modifiedPath.equals("/");
        }
        if (modifiedPath.endsWith("/*")) {
            String baseFilterPath = modifiedPath.substring(0, modifiedPath.length() - 1);
            return path.startsWith(baseFilterPath);
        }
        return modifiedPath.equals(path);
    }

    private static <K, V> void addToListMap(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }

    private static ServletChain servletChain(HttpHandler next, ManagedServlet managedServlet, String servletPath, DeploymentInfo deploymentInfo) {
        HttpHandler servletHandler = new ServletSecurityRoleHandler(next, deploymentInfo.getPrincipalVersusRolesMap());
        servletHandler = ServletPathMatches.wrapHandlers(servletHandler, managedServlet.getServletInfo().getHandlerChainWrappers());
        return new ServletChain(servletHandler, managedServlet, servletPath);
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    private static class MatchData {
        final ServletHandler handler;
        final String matchedPath;

        private MatchData(ServletHandler handler, String matchedPath) {
            this.handler = handler;
            this.matchedPath = matchedPath;
        }
    }
}

