/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private static final Locale LOCALE_US = Locale.US;
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static volatile String cachedDateString;
    private static volatile long nextUpdateTime;
    private static final ThreadLocal<SimpleDateFormat> RFC1123_PATTERN_FORMAT;
    private static final String RFC1036_PATTERN = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String ASCITIME_PATTERN = "EEE MMM d HH:mm:ss yyyyy";
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final String COMMON_LOG_PATTERN = "dd/MMM/yyyy:HH:mm:ss Z";
    private static final ThreadLocal<SimpleDateFormat> COMMON_LOG_PATTERN_FORMAT;

    public static String toDateString(Date date) {
        return RFC1123_PATTERN_FORMAT.get().format(date);
    }

    public static String toOldCookieDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(OLD_COOKIE_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        return dateFormat.format(date);
    }

    public static String toCommonLogFormat(Date date) {
        return COMMON_LOG_PATTERN_FORMAT.get().format(date);
    }

    public static Date parseDate(String date) {
        ParsePosition pp = new ParsePosition(0);
        SimpleDateFormat dateFormat = RFC1123_PATTERN_FORMAT.get();
        Date val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(RFC1036_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(ASCITIME_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(OLD_COOKIE_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        return null;
    }

    public static boolean handleIfModifiedSince(HttpServerExchange exchange, Date lastModified) {
        if (lastModified == null) {
            return true;
        }
        String modifiedSince = exchange.getRequestHeaders().getFirst(Headers.IF_MODIFIED_SINCE);
        if (modifiedSince == null) {
            return true;
        }
        Date modDate = DateUtils.parseDate(modifiedSince);
        if (modDate == null) {
            return true;
        }
        return lastModified.after(modDate);
    }

    public static boolean handleIfModifiedSince(String modifiedSince, Date lastModified) {
        if (lastModified == null) {
            return true;
        }
        if (modifiedSince == null) {
            return true;
        }
        Date modDate = DateUtils.parseDate(modifiedSince);
        if (modDate == null) {
            return true;
        }
        return lastModified.after(modDate);
    }

    public static boolean handleIfUnmodifiedSince(HttpServerExchange exchange, Date lastModified) {
        if (lastModified == null) {
            return true;
        }
        String modifiedSince = exchange.getRequestHeaders().getFirst(Headers.IF_UNMODIFIED_SINCE);
        if (modifiedSince == null) {
            return true;
        }
        Date modDate = DateUtils.parseDate(modifiedSince);
        if (modDate == null) {
            return true;
        }
        return lastModified.before(modDate);
    }

    public static boolean handleIfUnmodifiedSince(String modifiedSince, Date lastModified) {
        if (lastModified == null) {
            return true;
        }
        if (modifiedSince == null) {
            return true;
        }
        Date modDate = DateUtils.parseDate(modifiedSince);
        if (modDate == null) {
            return true;
        }
        return lastModified.after(modDate);
    }

    public static void addDateHeaderIfRequired(HttpServerExchange exchange) {
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (exchange.getConnection().getUndertowOptions().get(UndertowOptions.ALWAYS_SET_DATE, true) && !responseHeaders.contains(Headers.DATE)) {
            long time = System.nanoTime();
            if (time < nextUpdateTime) {
                responseHeaders.put(Headers.DATE, cachedDateString);
            } else {
                String dateString;
                long realTime = System.currentTimeMillis();
                cachedDateString = dateString = DateUtils.toDateString(new Date(realTime));
                nextUpdateTime = time + 1000000000L;
                responseHeaders.put(Headers.DATE, dateString);
            }
        }
    }

    private DateUtils() {
    }

    static {
        nextUpdateTime = -1L;
        RFC1123_PATTERN_FORMAT = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat(DateUtils.RFC1123_PATTERN, LOCALE_US);
                df.setTimeZone(GMT_ZONE);
                return df;
            }
        };
        COMMON_LOG_PATTERN_FORMAT = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat(DateUtils.COMMON_LOG_PATTERN, LOCALE_US);
                return df;
            }
        };
    }
}

