/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.impl.SingleSignOn;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Sessions;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.xnio.conduits.StreamSinkConduit;

public class SingleSignOnAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String SSO_SESSION_ATTRIBUTE = SingleSignOnAuthenticationMechanism.class.getName() + ".SSOID";
    private final Set<SessionManager> seenSessionManagers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private String cookieName = "JSESSIONIDSSO";
    private boolean httpOnly;
    private boolean secure;
    private String domain;
    private final SessionInvalidationListener listener = new SessionInvalidationListener();
    private final ResponseListener responseListener = new ResponseListener();
    private final SingleSignOnManager manager;

    public SingleSignOnAuthenticationMechanism(SingleSignOnManager storage) {
        this.manager = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Cookie cookie = exchange.getRequestCookies().get(this.cookieName);
        if (cookie != null) {
            SingleSignOn sso = this.manager.findSingleSignOn(cookie.getValue());
            if (sso != null) {
                try {
                    Account verified = securityContext.getIdentityManager().verify(sso.getAccount());
                    if (verified == null) {
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
                        return authenticationMechanismOutcome;
                    }
                    this.registerSessionIfRequired(exchange, sso);
                    securityContext.authenticationComplete(verified, sso.getMechanismName(), false);
                    AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    return authenticationMechanismOutcome;
                }
                finally {
                    sso.close();
                }
            }
            this.clearSsoCookie(exchange);
        }
        exchange.addResponseWrapper(this.responseListener);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private void registerSessionIfRequired(HttpServerExchange exchange, SingleSignOn sso) {
        Session session = this.getSession(exchange);
        if (!sso.contains(session)) {
            sso.add(session);
            session.setAttribute(SSO_SESSION_ATTRIBUTE, sso.getId());
            SessionManager manager = session.getSessionManager();
            if (this.seenSessionManagers.add(manager)) {
                manager.registerSessionListener(this.listener);
            }
        }
    }

    private void clearSsoCookie(HttpServerExchange exchange) {
        exchange.getResponseCookies().put(this.cookieName, new CookieImpl(this.cookieName).setMaxAge(0).setHttpOnly(this.httpOnly).setSecure(this.secure).setDomain(this.domain));
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    protected Session getSession(HttpServerExchange exchange) {
        return Sessions.getOrCreateSession(exchange);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public SingleSignOnAuthenticationMechanism setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public SingleSignOnAuthenticationMechanism setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public SingleSignOnAuthenticationMechanism setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public SingleSignOnAuthenticationMechanism setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    final class SessionInvalidationListener
    implements SessionListener {
        SessionInvalidationListener() {
        }

        @Override
        public void sessionCreated(Session session, HttpServerExchange exchange) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
            SingleSignOn sso;
            String ssoId = (String)session.getAttribute(SSO_SESSION_ATTRIBUTE);
            if (ssoId != null && (sso = SingleSignOnAuthenticationMechanism.this.manager.findSingleSignOn(ssoId)) != null) {
                try {
                    sso.remove(session);
                    if (reason == SessionListener.SessionDestroyedReason.INVALIDATED) {
                        for (Session associatedSession : sso) {
                            associatedSession.invalidate(null);
                        }
                        SingleSignOnAuthenticationMechanism.this.manager.removeSingleSignOn(ssoId);
                    }
                }
                finally {
                    sso.close();
                }
            }
        }

        @Override
        public void attributeAdded(Session session, String name, Object value) {
        }

        @Override
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        }

        @Override
        public void attributeRemoved(Session session, String name, Object oldValue) {
        }

        @Override
        public void sessionIdChanged(Session session, String oldSessionId) {
        }
    }

    final class ResponseListener
    implements ConduitWrapper<StreamSinkConduit> {
        ResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            SecurityContext sc = exchange.getSecurityContext();
            Account account = sc.getAuthenticatedAccount();
            if (account != null) {
                SingleSignOn sso = SingleSignOnAuthenticationMechanism.this.manager.createSingleSignOn(account, sc.getMechanismName());
                try {
                    SingleSignOnAuthenticationMechanism.this.registerSessionIfRequired(exchange, sso);
                    exchange.getResponseCookies().put(SingleSignOnAuthenticationMechanism.this.cookieName, new CookieImpl(SingleSignOnAuthenticationMechanism.this.cookieName, sso.getId()).setHttpOnly(SingleSignOnAuthenticationMechanism.this.httpOnly).setSecure(SingleSignOnAuthenticationMechanism.this.secure).setDomain(SingleSignOnAuthenticationMechanism.this.domain));
                }
                finally {
                    sso.close();
                }
            }
            return factory.create();
        }
    }
}

