/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.function.ChannelFunction;
import io.undertow.websockets.core.function.ChannelFunctionFileChannel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

public abstract class FixedPayloadFrameSourceChannel
extends StreamSourceFrameChannel {
    private final ChannelFunction[] functions;

    protected FixedPayloadFrameSourceChannel(WebSocketChannel wsChannel, WebSocketFrameType type, long payloadSize, int rsv, boolean finalFragment, Pooled<ByteBuffer> pooled, long frameLength, ChannelFunction ... functions) {
        super(wsChannel, type, payloadSize, rsv, finalFragment, pooled, frameLength);
        this.functions = functions;
    }

    @Override
    protected void handleHeaderData(FrameHeaderData headerData) {
        super.handleHeaderData(headerData);
        if (this.functions != null) {
            for (ChannelFunction func : this.functions) {
                func.newFrame(headerData);
            }
        }
    }

    @Override
    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        long r = this.functions != null && this.functions.length > 0 ? super.transferTo(position, count, new ChannelFunctionFileChannel(target, this.functions)) : super.transferTo(position, count, target);
        return r;
    }

    @Override
    public final long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return WebSocketUtils.transfer(this, count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int position = dst.position();
        int r = super.read(dst);
        if (r > 0) {
            this.afterRead(dst, position, r);
        }
        return r;
    }

    @Override
    public final long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Bounds[] old = new Bounds[length];
        for (int i = offset; i < length; ++i) {
            ByteBuffer dst = dsts[i];
            old[i - offset] = new Bounds(dst.position(), dst.limit());
        }
        long b = super.read(dsts, offset, length);
        if (b > 0L) {
            for (int i = offset; i < length; ++i) {
                ByteBuffer dst = dsts[i];
                int oldPos = old[i - offset].position;
                this.afterRead(dst, oldPos, dst.position() - oldPos);
            }
        }
        return b;
    }

    protected void afterRead(ByteBuffer buffer, int position, int length) throws IOException {
        block6: {
            try {
                for (ChannelFunction func : this.functions) {
                    func.afterRead(buffer, position, length);
                }
                if (!this.isComplete()) break block6;
                try {
                    for (ChannelFunction func : this.functions) {
                        func.complete();
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.getFramedChannel().markReadsBroken(e);
                    throw e;
                }
            }
            catch (UnsupportedEncodingException e) {
                this.getFramedChannel().markReadsBroken(e);
                throw e;
            }
        }
    }

    private static class Bounds {
        final int position;
        final int limit;

        Bounds(int position, int limit) {
            this.position = position;
            this.limit = limit;
        }
    }
}

