/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version13;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version13.WebSocket13Channel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.StreamConnection;

public class Hybi13Handshake
extends Hybi07Handshake {
    public Hybi13Handshake() {
        super(WebSocketVersion.V13, Collections.<String>emptySet(), false);
    }

    public Hybi13Handshake(Set<String> subprotocols, boolean allowExtensions) {
        super(WebSocketVersion.V13, subprotocols, allowExtensions);
    }

    @Override
    protected void handshakeInternal(WebSocketHttpExchange exchange) {
        String origin = exchange.getRequestHeader("Origin");
        if (origin != null) {
            exchange.setResponseHeader("Origin", origin);
        }
        this.selectSubprotocol(exchange);
        exchange.setResponseHeader("Sec-WebSocket-Location", Hybi13Handshake.getWebSocketLocation(exchange));
        String key = exchange.getRequestHeader("Sec-WebSocket-Key");
        try {
            String solution = this.solve(key);
            exchange.setResponseHeader("Sec-WebSocket-Accept", solution);
            this.performUpgrade(exchange);
        }
        catch (NoSuchAlgorithmException e) {
            IoUtils.safeClose((Closeable)exchange);
            exchange.endExchange();
            return;
        }
    }

    @Override
    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, StreamConnection channel, Pool<ByteBuffer> pool) {
        return new WebSocket13Channel(channel, pool, Hybi13Handshake.getWebSocketLocation(exchange), exchange.getResponseHeader("Sec-WebSocket-Protocol"), false, this.allowExtensions);
    }
}

