/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.io.BufferWritableOutputStream;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.servlet.DispatcherType;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.WriteListener;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class ServletOutputStreamImpl
extends ServletOutputStream
implements BufferWritableOutputStream {
    private final ServletRequestContext servletRequestContext;
    private Pooled<ByteBuffer> pooledBuffer;
    private ByteBuffer buffer;
    private Integer bufferSize;
    private StreamSinkChannel channel;
    private long written;
    private int state;
    private AsyncContextImpl asyncContext;
    private WriteListener listener;
    private WriteChannelListener internalListener;
    private ByteBuffer[] buffersToWrite;
    private FileChannel pendingFile;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;
    private static final int FLAG_READY = 4;
    private static final int FLAG_DELEGATE_SHUTDOWN = 8;
    private static final int FLAG_IN_CALLBACK = 16;
    private static final int MAX_BUFFERS_TO_ALLOCATE = 6;
    private CompositeThreadSetupAction threadSetupAction;

    public ServletOutputStreamImpl(ServletRequestContext servletRequestContext) {
        this.threadSetupAction = servletRequestContext.getDeployment().getThreadSetupAction();
        this.servletRequestContext = servletRequestContext;
    }

    public ServletOutputStreamImpl(ServletRequestContext servletRequestContext, int bufferSize) {
        this.bufferSize = bufferSize;
        this.servletRequestContext = servletRequestContext;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (len < 1) {
            return;
        }
        if (this.listener == null) {
            ByteBuffer buffer = this.buffer();
            if (buffer.remaining() < len) {
                StreamSinkChannel channel = this.channel;
                if (channel == null) {
                    this.channel = channel = this.servletRequestContext.getExchange().getResponseChannel();
                }
                Pool<ByteBuffer> bufferPool = this.servletRequestContext.getExchange().getConnection().getBufferPool();
                ByteBuffer[] buffers = new ByteBuffer[7];
                Pooled[] pooledBuffers = new Pooled[6];
                try {
                    int i;
                    buffers[0] = buffer;
                    int bytesWritten = 0;
                    int rem = buffer.remaining();
                    buffer.put(b, bytesWritten + off, rem);
                    buffer.flip();
                    bytesWritten += rem;
                    int bufferCount = 1;
                    for (i = 0; i < 6; ++i) {
                        Pooled<ByteBuffer> pooled;
                        pooledBuffers[bufferCount - 1] = pooled = bufferPool.allocate();
                        buffers[bufferCount++] = pooled.getResource();
                        int toWrite = len - bytesWritten;
                        ByteBuffer cb = pooled.getResource();
                        if (toWrite > cb.remaining()) {
                            rem = cb.remaining();
                            cb.put(b, bytesWritten + off, rem);
                            cb.flip();
                            bytesWritten += rem;
                            continue;
                        }
                        cb.put(b, bytesWritten + off, toWrite);
                        bytesWritten = len;
                        cb.flip();
                        break;
                    }
                    Channels.writeBlocking(channel, buffers, 0, bufferCount);
                    while (bytesWritten < len) {
                        bufferCount = 0;
                        for (i = 0; i < 7; ++i) {
                            ByteBuffer cb = buffers[i];
                            cb.clear();
                            ++bufferCount;
                            int toWrite = len - bytesWritten;
                            if (toWrite > cb.remaining()) {
                                rem = cb.remaining();
                                cb.put(b, bytesWritten + off, rem);
                                cb.flip();
                                bytesWritten += rem;
                                continue;
                            }
                            cb.put(b, bytesWritten + off, toWrite);
                            bytesWritten = len;
                            cb.flip();
                            break;
                        }
                        Channels.writeBlocking(channel, buffers, 0, bufferCount);
                    }
                    buffer.clear();
                }
                finally {
                    Pooled p;
                    for (int i = 0; i < pooledBuffers.length && (p = pooledBuffers[i]) != null; ++i) {
                        p.free();
                    }
                }
            } else {
                buffer.put(b, off, len);
                if (buffer.remaining() == 0) {
                    this.writeBufferBlocking(false);
                }
            }
            this.updateWritten(len);
        } else {
            if (Bits.anyAreClear(this.state, 4)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
            try {
                ByteBuffer buffer = this.buffer();
                if (buffer.remaining() > len) {
                    buffer.put(b, off, len);
                } else {
                    buffer.flip();
                    ByteBuffer userBuffer = ByteBuffer.wrap(b, off, len);
                    Buffer[] bufs = new ByteBuffer[]{buffer, userBuffer};
                    long toWrite = Buffers.remaining(bufs);
                    long written = 0L;
                    this.createChannel();
                    this.state |= 2;
                    do {
                        long res = this.channel.write((ByteBuffer[])bufs);
                        written += res;
                        if (res != 0L) continue;
                        ByteBuffer copy = ByteBuffer.allocate(userBuffer.remaining());
                        copy.put(userBuffer);
                        copy.flip();
                        this.buffersToWrite = new ByteBuffer[]{buffer, copy};
                        this.state &= 0xFFFFFFFB;
                        this.resumeWrites();
                        return;
                    } while (written < toWrite);
                    buffer.clear();
                }
            }
            finally {
                this.updateWrittenAsync(len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer[] buffers) throws IOException {
        ByteBuffer buffer;
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        int len = 0;
        for (ByteBuffer buf : buffers) {
            len += buf.remaining();
        }
        if (len < 1) {
            return;
        }
        if (this.listener == null) {
            if (this.written == 0L && (long)len == this.servletRequestContext.getOriginalResponse().getContentLength()) {
                if (this.channel == null) {
                    this.channel = this.servletRequestContext.getExchange().getResponseChannel();
                }
                Channels.writeBlocking(this.channel, buffers, 0, buffers.length);
                this.state |= 2;
            } else {
                buffer = this.buffer();
                if (len < buffer.remaining()) {
                    Buffers.copy(buffer, buffers, 0, buffers.length);
                } else {
                    if (this.channel == null) {
                        this.channel = this.servletRequestContext.getExchange().getResponseChannel();
                    }
                    if (buffer.position() == 0) {
                        Channels.writeBlocking(this.channel, buffers, 0, buffers.length);
                    } else {
                        ByteBuffer[] newBuffers = new ByteBuffer[buffers.length + 1];
                        buffer.flip();
                        newBuffers[0] = buffer;
                        System.arraycopy(buffers, 0, newBuffers, 1, buffers.length);
                        Channels.writeBlocking(this.channel, newBuffers, 0, newBuffers.length);
                        buffer.clear();
                    }
                    this.state |= 2;
                }
            }
            this.updateWritten(len);
        } else {
            if (Bits.anyAreClear(this.state, 4)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
            try {
                buffer = this.buffer();
                if (buffer.remaining() > len) {
                    Buffers.copy(buffer, buffers, 0, buffers.length);
                } else {
                    Buffer[] bufs = new ByteBuffer[buffers.length + 1];
                    buffer.flip();
                    bufs[0] = buffer;
                    System.arraycopy(buffers, 0, bufs, 1, buffers.length);
                    long toWrite = Buffers.remaining(bufs);
                    long written = 0L;
                    this.createChannel();
                    this.state |= 2;
                    do {
                        long res = this.channel.write((ByteBuffer[])bufs);
                        written += res;
                        if (res != 0L) continue;
                        ByteBuffer copy = ByteBuffer.allocate((int)Buffers.remaining(buffers));
                        Buffers.copy(copy, buffers, 0, buffers.length);
                        copy.flip();
                        this.buffersToWrite = new ByteBuffer[]{buffer, copy};
                        this.state &= 0xFFFFFFFB;
                        this.resumeWrites();
                        return;
                    } while (written < toWrite);
                    buffer.clear();
                }
            }
            finally {
                this.updateWrittenAsync(len);
            }
        }
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        this.write(new ByteBuffer[]{byteBuffer});
    }

    void updateWritten(long len) throws IOException {
        this.written += len;
        long contentLength = this.servletRequestContext.getOriginalResponse().getContentLength();
        if (contentLength != -1L && this.written >= contentLength) {
            this.close();
        }
    }

    void updateWrittenAsync(long len) throws IOException {
        this.written += len;
        long contentLength = this.servletRequestContext.getOriginalResponse().getContentLength();
        if (contentLength != -1L && this.written >= contentLength) {
            this.state |= 1;
            if (this.buffersToWrite == null && this.pendingFile == null) {
                if (this.flushBufferAsync(true)) {
                    this.channel.shutdownWrites();
                    this.state |= 8;
                    if (!this.channel.flush()) {
                        this.resumeWrites();
                    }
                } else {
                    this.resumeWrites();
                }
            }
        }
    }

    private void resumeWrites() {
        if (Bits.anyAreSet(this.state, 16)) {
            return;
        }
        if (this.channel != null) {
            this.channel.getWriteSetter().set(this.internalListener);
            this.channel.resumeWrites();
        } else {
            this.servletRequestContext.getExchange().getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelListeners.invokeChannelListener(null, ServletOutputStreamImpl.this.internalListener);
                }
            });
        }
    }

    private boolean flushBufferAsync(boolean writeFinal) throws IOException {
        long toWrite;
        Buffer[] bufs = this.buffersToWrite;
        if (bufs == null) {
            ByteBuffer buffer = this.buffer;
            if (buffer == null || buffer.position() == 0) {
                return true;
            }
            buffer.flip();
            bufs = new ByteBuffer[]{buffer};
        }
        if ((toWrite = Buffers.remaining(bufs)) == 0L) {
            this.buffer.clear();
            return true;
        }
        this.state |= 2;
        this.createChannel();
        long written = 0L;
        do {
            long res = writeFinal ? this.channel.writeFinal((ByteBuffer[])bufs) : this.channel.write((ByteBuffer[])bufs);
            written += res;
            if (res != 0L) continue;
            this.state &= 0xFFFFFFFB;
            this.buffersToWrite = bufs;
            return false;
        } while (written < toWrite);
        this.buffer.clear();
        return true;
    }

    ByteBuffer underlyingBuffer() {
        if (Bits.anyAreSet(this.state, 1)) {
            return null;
        }
        return this.buffer();
    }

    @Override
    public void flush() throws IOException {
        if (this.servletRequestContext.getOriginalRequest().getDispatcherType() == DispatcherType.INCLUDE) {
            return;
        }
        if (this.servletRequestContext.getDeployment().getDeploymentInfo().isIgnoreFlush() && this.servletRequestContext.getExchange().isRequestComplete() && this.servletRequestContext.getOriginalResponse().getHeader("Transfer-Encoding") == null) {
            this.servletRequestContext.getOriginalResponse().setIgnoredFlushPerformed(true);
            return;
        }
        this.flushInternal();
    }

    public void flushInternal() throws IOException {
        if (this.listener == null) {
            if (Bits.anyAreSet(this.state, 1)) {
                return;
            }
            if (this.buffer != null && this.buffer.position() != 0) {
                this.writeBufferBlocking(false);
            }
            if (this.channel == null) {
                this.channel = this.servletRequestContext.getExchange().getResponseChannel();
            }
            Channels.flushBlocking(this.channel);
        } else {
            long res;
            if (Bits.anyAreClear(this.state, 4)) {
                return;
            }
            this.createChannel();
            if (this.buffer == null || this.buffer.position() == 0) {
                this.channel.flush();
                return;
            }
            this.state |= 2;
            this.buffer.flip();
            do {
                res = this.channel.write(this.buffer);
                this.written += res;
            } while (this.buffer.hasRemaining() && res != 0L);
            if (!this.buffer.hasRemaining()) {
                this.channel.flush();
            }
            this.buffer.compact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFrom(FileChannel source) throws IOException {
        if (this.listener == null) {
            if (Bits.anyAreSet(this.state, 1)) {
                return;
            }
            if (this.buffer != null && this.buffer.position() != 0) {
                this.writeBufferBlocking(false);
            }
            if (this.channel == null) {
                this.channel = this.servletRequestContext.getExchange().getResponseChannel();
            }
            long position = source.position();
            long count = source.size() - position;
            Channels.transferBlocking(this.channel, source, position, count);
            this.updateWritten(count);
        } else {
            this.state |= 2;
            this.createChannel();
            long pos = 0L;
            try {
                long size = source.size();
                pos = source.position();
                while (size - pos > 0L) {
                    long ret = this.channel.transferFrom(this.pendingFile, pos, size - pos);
                    if (ret <= 0L) {
                        this.state &= 0xFFFFFFFB;
                        this.pendingFile = source;
                        source.position(pos);
                        this.resumeWrites();
                        return;
                    }
                    pos += ret;
                }
            }
            finally {
                this.updateWrittenAsync(pos - source.position());
            }
        }
    }

    private void writeBufferBlocking(boolean writeFinal) throws IOException {
        if (this.channel == null) {
            this.channel = this.servletRequestContext.getExchange().getResponseChannel();
        }
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            if (writeFinal) {
                this.channel.writeFinal(this.buffer);
            } else {
                this.channel.write(this.buffer);
            }
            if (!this.buffer.hasRemaining()) continue;
            this.channel.awaitWritable();
        }
        this.buffer.clear();
        this.state |= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        if (this.servletRequestContext.getOriginalRequest().getDispatcherType() == DispatcherType.INCLUDE) {
            return;
        }
        if (this.listener == null) {
            if (Bits.anyAreSet(this.state, 1)) {
                return;
            }
            this.state |= 1;
            this.state &= 0xFFFFFFFB;
            if (Bits.allAreClear(this.state, 2) && this.channel == null && this.servletRequestContext.getOriginalResponse().getHeader("Content-Length") == null && this.servletRequestContext.getOriginalResponse().getHeader("Transfer-Encoding") == null) {
                if (this.buffer == null) {
                    this.servletRequestContext.getExchange().getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                } else {
                    this.servletRequestContext.getExchange().getResponseHeaders().put(Headers.CONTENT_LENGTH, Integer.toString(this.buffer.position()));
                }
            }
            try {
                if (this.buffer != null) {
                    this.writeBufferBlocking(true);
                }
                if (this.channel == null) {
                    this.channel = this.servletRequestContext.getExchange().getResponseChannel();
                }
                this.state |= 8;
                StreamSinkChannel channel = this.channel;
                if (channel == null) return;
                channel.shutdownWrites();
                Channels.flushBlocking(channel);
                return;
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.free();
                    this.buffer = null;
                } else {
                    this.buffer = null;
                }
            }
        } else {
            this.closeAsync();
        }
    }

    public void closeAsync() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        this.state |= 1;
        this.state &= 0xFFFFFFFB;
        if (Bits.allAreClear(this.state, 2) && this.channel == null && this.servletRequestContext.getOriginalResponse().getHeader("Transfer-Encoding") == null) {
            if (this.buffer == null) {
                this.servletRequestContext.getOriginalResponse().setHeader(Headers.CONTENT_LENGTH, "0");
            } else {
                this.servletRequestContext.getOriginalResponse().setHeader(Headers.CONTENT_LENGTH, Integer.toString(this.buffer.position()));
            }
        }
        this.createChannel();
        if (this.buffer != null) {
            if (!this.flushBufferAsync(true)) {
                this.resumeWrites();
                return;
            }
            if (this.pooledBuffer != null) {
                this.pooledBuffer.free();
                this.buffer = null;
            } else {
                this.buffer = null;
            }
        }
        this.channel.shutdownWrites();
        this.state |= 8;
        if (!this.channel.flush()) {
            this.resumeWrites();
        }
    }

    private void createChannel() {
        if (this.channel == null) {
            this.channel = this.servletRequestContext.getExchange().getResponseChannel();
            this.channel.getWriteSetter().set(this.internalListener);
        }
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        if (this.bufferSize != null) {
            this.buffer = ByteBuffer.allocateDirect(this.bufferSize);
            return this.buffer;
        }
        this.pooledBuffer = this.servletRequestContext.getExchange().getConnection().getBufferPool().allocate();
        this.buffer = this.pooledBuffer.getResource();
        return this.buffer;
    }

    public void resetBuffer() {
        if (Bits.allAreClear(this.state, 2)) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.free();
                this.pooledBuffer = null;
            }
        } else {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.buffer = null;
    }

    public void setBufferSize(int size) {
        if (this.buffer != null) {
            throw UndertowServletMessages.MESSAGES.contentHasBeenWritten();
        }
        this.bufferSize = size;
    }

    public boolean isClosed() {
        return Bits.anyAreSet(this.state, 1);
    }

    @Override
    public boolean isReady() {
        if (this.listener == null) {
            throw UndertowServletMessages.MESSAGES.streamNotInAsyncMode();
        }
        return Bits.anyAreSet(this.state, 4);
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw UndertowServletMessages.MESSAGES.listenerCannotBeNull();
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        ServletRequest servletRequest = this.servletRequestContext.getServletRequest();
        if (!servletRequest.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.asyncContext = (AsyncContextImpl)servletRequest.getAsyncContext();
        this.listener = writeListener;
        this.internalListener = new WriteChannelListener();
        this.internalListener.handleEvent((StreamSinkChannel)null);
    }

    ServletRequestContext getServletRequestContext() {
        return this.servletRequestContext;
    }

    static /* synthetic */ ByteBuffer[] access$602(ServletOutputStreamImpl x0, ByteBuffer[] x1) {
        x0.buffersToWrite = x1;
        return x1;
    }

    private class WriteChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private WriteChannelListener() {
        }

        @Override
        public void handleEvent(StreamSinkChannel aChannel) {
            if (ServletOutputStreamImpl.this.channel != null) {
                ServletOutputStreamImpl.this.channel.suspendWrites();
            }
            ServletOutputStreamImpl.this.asyncContext.addAsyncTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (Bits.anyAreSet(ServletOutputStreamImpl.this.state, 8)) {
                        try {
                            if (ServletOutputStreamImpl.this.channel.flush()) return;
                            ServletOutputStreamImpl.this.resumeWrites();
                            return;
                        }
                        catch (IOException e) {
                            WriteChannelListener.this.handleError(e);
                            return;
                        }
                    }
                    if (ServletOutputStreamImpl.this.buffersToWrite != null) {
                        long toWrite = Buffers.remaining(ServletOutputStreamImpl.this.buffersToWrite);
                        long written = 0L;
                        do {
                            try {
                                long res = ServletOutputStreamImpl.this.channel.write(ServletOutputStreamImpl.this.buffersToWrite);
                                written += res;
                                if (res == 0L) {
                                    ServletOutputStreamImpl.this.resumeWrites();
                                    return;
                                }
                            }
                            catch (IOException e) {
                                WriteChannelListener.this.handleError(e);
                                return;
                            }
                        } while (written < toWrite);
                        ServletOutputStreamImpl.access$602(ServletOutputStreamImpl.this, null);
                    }
                    if (ServletOutputStreamImpl.this.pendingFile != null) {
                        try {
                            long size = ServletOutputStreamImpl.this.pendingFile.size();
                            long pos = ServletOutputStreamImpl.this.pendingFile.position();
                            while (size - pos > 0L) {
                                long ret = ServletOutputStreamImpl.this.channel.transferFrom(ServletOutputStreamImpl.this.pendingFile, pos, size - pos);
                                if (ret <= 0L) {
                                    ServletOutputStreamImpl.this.pendingFile.position(pos);
                                    ServletOutputStreamImpl.this.resumeWrites();
                                    return;
                                }
                                pos += ret;
                            }
                            ServletOutputStreamImpl.this.pendingFile = null;
                        }
                        catch (IOException e) {
                            WriteChannelListener.this.handleError(e);
                            return;
                        }
                    }
                    if (Bits.anyAreSet(ServletOutputStreamImpl.this.state, 1)) {
                        try {
                            if (ServletOutputStreamImpl.this.pooledBuffer != null) {
                                ServletOutputStreamImpl.this.pooledBuffer.free();
                                ServletOutputStreamImpl.this.buffer = null;
                            } else {
                                ServletOutputStreamImpl.this.buffer = null;
                            }
                            ServletOutputStreamImpl.this.channel.shutdownWrites();
                            ServletOutputStreamImpl.this.state |= 8;
                            if (ServletOutputStreamImpl.this.channel.flush()) return;
                            ServletOutputStreamImpl.this.resumeWrites();
                            return;
                        }
                        catch (IOException e) {
                            WriteChannelListener.this.handleError(e);
                            return;
                        }
                    }
                    if (ServletOutputStreamImpl.this.asyncContext.isDispatched()) {
                        return;
                    }
                    ServletOutputStreamImpl.this.state |= 4;
                    try {
                        ServletOutputStreamImpl.this.state |= 16;
                        ThreadSetupAction.Handle handle = ServletOutputStreamImpl.this.threadSetupAction.setup(ServletOutputStreamImpl.this.servletRequestContext.getExchange());
                        try {
                            ServletOutputStreamImpl.this.listener.onWritePossible();
                        }
                        finally {
                            handle.tearDown();
                        }
                        if (ServletOutputStreamImpl.this.isReady()) return;
                        ServletOutputStreamImpl.this.state &= -17;
                        ServletOutputStreamImpl.this.resumeWrites();
                        return;
                    }
                    catch (Throwable e) {
                        IoUtils.safeClose((Closeable)ServletOutputStreamImpl.this.channel);
                        return;
                    }
                    finally {
                        ServletOutputStreamImpl.this.state &= -17;
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleError(IOException e) {
            try {
                ThreadSetupAction.Handle handle = ServletOutputStreamImpl.this.threadSetupAction.setup(ServletOutputStreamImpl.this.servletRequestContext.getExchange());
                try {
                    ServletOutputStreamImpl.this.listener.onError(e);
                }
                finally {
                    handle.tearDown();
                }
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(ServletOutputStreamImpl.this.channel, ServletOutputStreamImpl.this.servletRequestContext.getExchange().getConnection());
                throw throwable;
            }
            IoUtils.safeClose(ServletOutputStreamImpl.this.channel, ServletOutputStreamImpl.this.servletRequestContext.getExchange().getConnection());
        }
    }
}

