/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public class DeflatingStreamSinkConduit
implements StreamSinkConduit {
    protected final Deflater deflater;
    private final ConduitFactory<StreamSinkConduit> conduitFactory;
    private final HttpServerExchange exchange;
    private StreamSinkConduit next;
    private WriteReadyHandler writeReadyHandler;
    protected final Pooled<ByteBuffer> currentBuffer;
    private ByteBuffer additionalBuffer;
    private int state = 0;
    private static final int SHUTDOWN = 1;
    private static final int NEXT_SHUTDOWN = 2;
    private static final int FLUSHING_BUFFER = 4;
    private static final int WRITES_RESUMED = 8;
    private static final int CLOSED = 16;
    private static final int WRITTEN_TRAILER = 32;

    public DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange) {
        this(conduitFactory, exchange, 8);
    }

    protected DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange, int deflateLevel) {
        this.deflater = new Deflater(deflateLevel, true);
        this.currentBuffer = exchange.getConnection().getBufferPool().allocate();
        this.exchange = exchange;
        this.conduitFactory = conduitFactory;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(17, this.state)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0;
        }
        if (src.remaining() == 0) {
            return 0;
        }
        if (!this.deflater.needsInput()) {
            this.deflateData();
            if (!this.deflater.needsInput()) {
                return 0;
            }
        }
        byte[] data = new byte[src.remaining()];
        src.get(data);
        this.preDeflate(data);
        this.deflater.setInput(data);
        this.deflateData();
        return data.length;
    }

    protected void preDeflate(byte[] data) {
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet(17, this.state)) {
            throw new ClosedChannelException();
        }
        int total = 0;
        for (int i = offset; i < offset + length; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            int ret = this.write(srcs[i]);
            total += ret;
            if (ret != 0) continue;
            return total;
        }
        return total;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(17, this.state)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(17, this.state)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public XnioWorker getWorker() {
        return this.exchange.getConnection().getWorker();
    }

    @Override
    public void suspendWrites() {
        if (this.next == null) {
            this.state &= 0xFFFFFFF7;
        } else {
            this.next.suspendWrites();
        }
    }

    @Override
    public boolean isWriteResumed() {
        if (this.next == null) {
            return Bits.anyAreSet(8, this.state);
        }
        return this.next.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        if (this.next == null) {
            this.resumeWrites();
        } else {
            this.next.wakeupWrites();
        }
    }

    @Override
    public void resumeWrites() {
        if (this.next == null) {
            this.state |= 8;
            this.queueWriteListener();
        } else {
            this.next.resumeWrites();
        }
    }

    private void queueWriteListener() {
        this.exchange.getConnection().getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                if (DeflatingStreamSinkConduit.this.writeReadyHandler != null) {
                    try {
                        DeflatingStreamSinkConduit.this.writeReadyHandler.writeReady();
                    }
                    finally {
                        if (DeflatingStreamSinkConduit.this.next == null && DeflatingStreamSinkConduit.this.isWriteResumed()) {
                            DeflatingStreamSinkConduit.this.queueWriteListener();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void terminateWrites() throws IOException {
        this.deflater.finish();
        this.state |= 1;
    }

    @Override
    public boolean isWriteShutdown() {
        return Bits.anyAreSet(this.state, 1);
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.exchange.getConnection().getIoThread();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        boolean nextCreated = false;
        try {
            if (Bits.anyAreSet(1, this.state)) {
                if (Bits.anyAreSet(2, this.state)) {
                    boolean bl = this.next.flush();
                    return bl;
                }
                if (!this.performFlushIfRequired()) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.deflater.finished()) {
                    this.deflateData();
                    if (!this.deflater.finished()) {
                        boolean bl = false;
                        return bl;
                    }
                }
                ByteBuffer buffer = this.currentBuffer.getResource();
                if (Bits.allAreClear(32, this.state)) {
                    this.state |= 0x20;
                    byte[] data = this.getTrailer();
                    if (data != null) {
                        if (data.length <= buffer.remaining()) {
                            buffer.put(data);
                        } else if (this.additionalBuffer == null) {
                            this.additionalBuffer = ByteBuffer.wrap(data);
                        } else {
                            byte[] newData = new byte[this.additionalBuffer.remaining() + data.length];
                            int pos = 0;
                            while (this.additionalBuffer.hasRemaining()) {
                                newData[pos++] = this.additionalBuffer.get();
                            }
                            for (byte aData : data) {
                                newData[pos++] = aData;
                            }
                            this.additionalBuffer = ByteBuffer.wrap(newData);
                        }
                    }
                }
                if (!Bits.anyAreSet(4, this.state)) {
                    buffer.flip();
                    this.state |= 4;
                    if (this.next == null) {
                        nextCreated = true;
                        this.next = this.createNextChannel();
                    }
                }
                if (this.performFlushIfRequired()) {
                    this.state |= 2;
                    this.currentBuffer.free();
                    this.next.terminateWrites();
                    boolean bl = this.next.flush();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = this.performFlushIfRequired();
            return bl;
        }
        finally {
            if (nextCreated && Bits.anyAreSet(8, this.state) && !Bits.anyAreSet(2, this.state)) {
                this.next.resumeWrites();
            }
        }
    }

    protected byte[] getTrailer() {
        return null;
    }

    private boolean performFlushIfRequired() throws IOException {
        if (Bits.anyAreSet(4, this.state)) {
            ByteBuffer[] bufs = new ByteBuffer[this.additionalBuffer == null ? 1 : 2];
            long totalLength = 0L;
            bufs[0] = this.currentBuffer.getResource();
            totalLength += (long)bufs[0].remaining();
            if (this.additionalBuffer != null) {
                bufs[1] = this.additionalBuffer;
                totalLength += (long)bufs[1].remaining();
            }
            if (totalLength > 0L) {
                long total = 0L;
                long res = 0L;
                do {
                    res = this.next.write(bufs, 0, bufs.length);
                    total += res;
                    if (res != 0L) continue;
                    return false;
                } while (total < totalLength);
            }
            this.additionalBuffer = null;
            this.currentBuffer.getResource().clear();
            this.state &= 0xFFFFFFFB;
        }
        return true;
    }

    private StreamSinkConduit createNextChannel() {
        if (this.deflater.finished()) {
            int remaining = this.currentBuffer.getResource().remaining();
            if (this.additionalBuffer != null) {
                remaining += this.additionalBuffer.remaining();
            }
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Integer.toString(remaining));
        } else {
            this.exchange.getResponseHeaders().remove(Headers.CONTENT_LENGTH);
        }
        return this.conduitFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deflateData() throws IOException {
        boolean nextCreated = false;
        try {
            Pooled<ByteBuffer> pooled = this.currentBuffer;
            ByteBuffer outputBuffer = pooled.getResource();
            boolean shutdown = Bits.anyAreSet(1, this.state);
            byte[] buffer = new byte[1024];
            while (!this.deflater.needsInput() || shutdown && !this.deflater.finished()) {
                int count = this.deflater.deflate(buffer);
                if (count == 0) continue;
                int remaining = outputBuffer.remaining();
                if (remaining > count) {
                    outputBuffer.put(buffer, 0, count);
                    continue;
                }
                if (remaining == count) {
                    outputBuffer.put(buffer, 0, count);
                } else {
                    outputBuffer.put(buffer, 0, remaining);
                    this.additionalBuffer = ByteBuffer.wrap(buffer, remaining, count - remaining);
                }
                outputBuffer.flip();
                this.state |= 4;
                if (this.next == null) {
                    nextCreated = true;
                    this.next = this.createNextChannel();
                }
                if (this.performFlushIfRequired()) continue;
                return;
            }
        }
        finally {
            if (nextCreated && Bits.anyAreSet(8, this.state)) {
                this.next.resumeWrites();
            }
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        if (!Bits.anyAreSet(2, this.state)) {
            this.currentBuffer.free();
        }
        this.state |= 0x10;
        this.next.truncateWrites();
    }
}

