/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;

public class ServletRegistrationImpl
implements ServletRegistration,
ServletRegistration.Dynamic {
    private final ServletInfo servletInfo;
    private final Deployment deployment;

    public ServletRegistrationImpl(ServletInfo servletInfo, Deployment deployment) {
        this.servletInfo = servletInfo;
        this.deployment = deployment;
    }

    @Override
    public void setLoadOnStartup(int loadOnStartup) {
        this.servletInfo.setLoadOnStartup(loadOnStartup);
    }

    @Override
    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        if (constraint == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("constraint");
        }
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        HashSet<String> urlPatterns = new HashSet<String>();
        for (SecurityConstraint securityConstraint : deploymentInfo.getSecurityConstraints()) {
            for (WebResourceCollection webResources : securityConstraint.getWebResourceCollections()) {
                urlPatterns.addAll(webResources.getUrlPatterns());
            }
        }
        HashSet<String> ret = new HashSet<String>();
        for (String url : this.servletInfo.getMappings()) {
            if (!urlPatterns.contains(url)) continue;
            ret.add(url);
        }
        ServletSecurityInfo servletSecurityInfo = new ServletSecurityInfo();
        this.servletInfo.setServletSecurityInfo(servletSecurityInfo);
        ((ServletSecurityInfo)((ServletSecurityInfo)servletSecurityInfo.setTransportGuaranteeType(constraint.getTransportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).setEmptyRoleSemantic(this.emptyRoleSemantic(constraint.getEmptyRoleSemantic()))).addRolesAllowed(constraint.getRolesAllowed());
        for (HttpMethodConstraintElement methodConstraint : constraint.getHttpMethodConstraints()) {
            servletSecurityInfo.addHttpMethodSecurityInfo((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setTransportGuaranteeType(methodConstraint.getTransportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).setMethod(methodConstraint.getMethodName()).setEmptyRoleSemantic(this.emptyRoleSemantic(methodConstraint.getEmptyRoleSemantic()))).addRolesAllowed(methodConstraint.getRolesAllowed()));
        }
        return ret;
    }

    private SecurityInfo.EmptyRoleSemantic emptyRoleSemantic(ServletSecurity.EmptyRoleSemantic emptyRoleSemantic) {
        switch (emptyRoleSemantic) {
            case PERMIT: {
                return SecurityInfo.EmptyRoleSemantic.PERMIT;
            }
            case DENY: {
                return SecurityInfo.EmptyRoleSemantic.DENY;
            }
        }
        return null;
    }

    @Override
    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.servletInfo.setMultipartConfig(multipartConfig);
    }

    @Override
    public void setRunAsRole(String roleName) {
        this.servletInfo.setRunAs(roleName);
    }

    @Override
    public void setAsyncSupported(boolean isAsyncSupported) {
        this.servletInfo.setAsyncSupported(isAsyncSupported);
    }

    @Override
    public Set<String> addMapping(String ... urlPatterns) {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        HashSet<String> ret = new HashSet<String>();
        HashSet<String> existing = new HashSet<String>();
        for (ServletInfo s : deploymentInfo.getServlets().values()) {
            if (s.getName().equals(this.servletInfo.getName())) continue;
            existing.addAll(s.getMappings());
        }
        for (String pattern : urlPatterns) {
            if (!existing.contains(pattern)) continue;
            ret.add(pattern);
        }
        if (ret.isEmpty()) {
            for (String pattern : urlPatterns) {
                if (this.servletInfo.getMappings().contains(pattern)) continue;
                this.servletInfo.addMapping(pattern);
            }
        }
        this.deployment.getServletPaths().invalidate();
        return ret;
    }

    @Override
    public Collection<String> getMappings() {
        return this.servletInfo.getMappings();
    }

    @Override
    public String getRunAsRole() {
        return this.servletInfo.getRunAs();
    }

    @Override
    public String getName() {
        return this.servletInfo.getName();
    }

    @Override
    public String getClassName() {
        return this.servletInfo.getServletClass().getName();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.servletInfo.getInitParams().containsKey(name)) {
            return false;
        }
        this.servletInfo.addInitParam(name, value);
        return true;
    }

    @Override
    public String getInitParameter(String name) {
        return this.servletInfo.getInitParams().get(name);
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (this.setInitParameter(entry.getKey(), entry.getValue())) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this.servletInfo.getInitParams();
    }
}

