/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import java.net.URI;
import java.net.URISyntaxException;

public class NodeConfig {
    private final String jvmRoute;
    private final URI connectionURI;
    private final String balancer;
    private final String domain;
    private boolean flushPackets;
    private final int flushwait;
    private final int ping;
    private final int smax;
    private final int ttl;
    private final int timeout;

    NodeConfig(NodeBuilder b, URI connectionURI) {
        this.connectionURI = connectionURI;
        this.balancer = b.balancer;
        this.domain = b.domain;
        this.jvmRoute = b.jvmRoute;
        this.flushPackets = b.flushPackets;
        this.flushwait = b.flushwait;
        this.ping = b.ping;
        this.smax = b.smax;
        this.ttl = b.ttl;
        this.timeout = b.timeout;
    }

    public URI getConnectionURI() {
        return this.connectionURI;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getFlushwait() {
        return this.flushwait;
    }

    public int getPing() {
        return this.ping;
    }

    public int getSmax() {
        return this.smax;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getBalancer() {
        return this.balancer;
    }

    public boolean isFlushPackets() {
        return this.flushPackets;
    }

    public void setFlushPackets(boolean flushPackets) {
        this.flushPackets = flushPackets;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public static NodeBuilder builder() {
        return new NodeBuilder();
    }

    public static class NodeBuilder {
        private String jvmRoute;
        private String balancer = "mycluster";
        private String domain = null;
        private String type = "http";
        private String hostname;
        private int port;
        private boolean flushPackets = false;
        private int flushwait = 10;
        private int ping = 10000;
        private int smax;
        private int ttl = 60000;
        private int timeout = 0;

        NodeBuilder() {
        }

        public NodeBuilder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public NodeBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        public NodeBuilder setType(String type) {
            this.type = type;
            return this;
        }

        public NodeBuilder setBalancer(String balancer) {
            this.balancer = balancer;
            return this;
        }

        public NodeBuilder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public NodeBuilder setJvmRoute(String jvmRoute) {
            this.jvmRoute = jvmRoute;
            return this;
        }

        public NodeBuilder setFlushPackets(boolean flushPackets) {
            this.flushPackets = flushPackets;
            return this;
        }

        public NodeBuilder setFlushwait(int flushwait) {
            this.flushwait = flushwait;
            return this;
        }

        public NodeBuilder setPing(int ping) {
            this.ping = ping;
            return this;
        }

        public NodeBuilder setSmax(int smax) {
            this.smax = smax;
            return this;
        }

        public NodeBuilder setTtl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public NodeBuilder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public NodeConfig build() throws URISyntaxException {
            URI uri = new URI(this.type, null, this.hostname, this.port, "/", "", "");
            return new NodeConfig(this, uri);
        }
    }
}

