/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.OpenListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public final class WriteTimeoutStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private XnioExecutor.Key handle;
    private final StreamConnection connection;
    private volatile long expireTime = -1L;
    private final OpenListener openListener;
    private static final int FUZZ_FACTOR = 50;
    private final Runnable timeoutCommand = new Runnable(){

        @Override
        public void run() {
            WriteTimeoutStreamSinkConduit.this.handle = null;
            if (WriteTimeoutStreamSinkConduit.this.expireTime == -1L) {
                return;
            }
            long current = System.currentTimeMillis();
            if (current < WriteTimeoutStreamSinkConduit.this.expireTime) {
                WriteTimeoutStreamSinkConduit.this.handle = WriteTimeoutStreamSinkConduit.this.connection.getIoThread().executeAfter(WriteTimeoutStreamSinkConduit.this.timeoutCommand, WriteTimeoutStreamSinkConduit.this.expireTime - current + 50L, TimeUnit.MILLISECONDS);
                return;
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            IoUtils.safeClose((Closeable)WriteTimeoutStreamSinkConduit.this.connection);
            if (WriteTimeoutStreamSinkConduit.this.connection.getSourceChannel().isReadResumed()) {
                ChannelListeners.invokeChannelListener(WriteTimeoutStreamSinkConduit.this.connection.getSourceChannel(), WriteTimeoutStreamSinkConduit.this.connection.getSourceChannel().getReadListener());
            }
            if (WriteTimeoutStreamSinkConduit.this.connection.getSinkChannel().isWriteResumed()) {
                ChannelListeners.invokeChannelListener(WriteTimeoutStreamSinkConduit.this.connection.getSinkChannel(), WriteTimeoutStreamSinkConduit.this.connection.getSinkChannel().getWriteListener());
            }
        }
    };

    public WriteTimeoutStreamSinkConduit(StreamSinkConduit delegate, StreamConnection connection, OpenListener openListener) {
        super(delegate);
        this.connection = connection;
        this.openListener = openListener;
    }

    private void handleWriteTimeout(long ret) throws IOException {
        if (!this.connection.isOpen()) {
            return;
        }
        if (ret == 0L && this.handle != null) {
            return;
        }
        Integer timeout = this.getTimeout();
        if (timeout == null || timeout <= 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long expireTimeVar = this.expireTime;
        if (expireTimeVar != -1L && currentTime > expireTimeVar) {
            IoUtils.safeClose((Closeable)this.connection);
            throw new ClosedChannelException();
        }
        this.expireTime = currentTime + (long)timeout.intValue();
        XnioExecutor.Key key = this.handle;
        if (key == null) {
            this.handle = this.connection.getIoThread().executeAfter(this.timeoutCommand, timeout.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int ret = super.write(src);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = super.write(srcs, offset, length);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        int ret = super.writeFinal(src);
        this.handleWriteTimeout(ret);
        if (!src.hasRemaining() && this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
        return ret;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = super.writeFinal(srcs, offset, length);
        this.handleWriteTimeout(ret);
        if (!Buffers.hasRemaining(srcs) && this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
        return ret;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long ret = super.transferFrom(src, position, count);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long ret = super.transferFrom(source, count, throughBuffer);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public void awaitWritable() throws IOException {
        Integer timeout = this.getTimeout();
        if (timeout != null && timeout > 0) {
            super.awaitWritable(timeout + 50, TimeUnit.MILLISECONDS);
        } else {
            super.awaitWritable();
        }
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Integer timeout = this.getTimeout();
        if (timeout != null && timeout > 0) {
            long millis = timeUnit.toMillis(time);
            super.awaitWritable(Math.min(millis, (long)(timeout + 50)), TimeUnit.MILLISECONDS);
        } else {
            super.awaitWritable(time, timeUnit);
        }
    }

    private Integer getTimeout() throws IOException {
        Integer timeout = this.connection.getSourceChannel().getOption(Options.WRITE_TIMEOUT);
        Integer idleTimeout = this.openListener.getUndertowOptions().get(UndertowOptions.IDLE_TIMEOUT);
        if ((timeout == null || timeout <= 0) && idleTimeout != null) {
            timeout = idleTimeout;
        } else if (timeout != null && idleTimeout != null && idleTimeout > 0) {
            timeout = Math.min(timeout, idleTimeout);
        }
        return timeout;
    }

    @Override
    public void terminateWrites() throws IOException {
        super.terminateWrites();
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        super.truncateWrites();
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }
}

