/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.protocols.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pooled;

public class SpdySynReplyStreamSinkChannel
extends SpdyStreamStreamSinkChannel {
    private final HeaderMap headers = new HeaderMap();
    private boolean first = true;
    private final Deflater deflater;
    private ChannelListener<SpdySynReplyStreamSinkChannel> completionListener;

    SpdySynReplyStreamSinkChannel(SpdyChannel channel, int streamId, Deflater deflater) {
        super(channel, streamId);
        this.deflater = deflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        int fcWindow = this.grabFlowControlBytes(this.getBuffer().remaining());
        if (fcWindow == 0 && this.getBuffer().hasRemaining()) {
            return new SendFrameHeader(this.getBuffer().remaining(), null);
        }
        boolean finalFrame = this.isWritesShutdown() && fcWindow >= this.getBuffer().remaining();
        Pooled<ByteBuffer> firstHeaderBuffer = ((SpdyChannel)this.getChannel()).getBufferPool().allocate();
        Pooled<ByteBuffer>[] allHeaderBuffers = null;
        ByteBuffer firstBuffer = firstHeaderBuffer.getResource();
        boolean firstFrame = false;
        if (this.first) {
            firstFrame = true;
            this.first = false;
            int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 2;
            SpdyProtocolUtils.putInt(firstBuffer, firstInt);
            SpdyProtocolUtils.putInt(firstBuffer, 0);
            HeaderMap headers = this.headers;
            SpdyProtocolUtils.putInt(firstBuffer, this.getStreamId());
            headers.remove(Headers.CONNECTION);
            headers.remove(Headers.KEEP_ALIVE);
            headers.remove(Headers.TRANSFER_ENCODING);
            allHeaderBuffers = this.createHeaderBlock(firstHeaderBuffer, allHeaderBuffers, firstBuffer, headers);
        }
        Pooled<ByteBuffer> currentPooled = allHeaderBuffers == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
        ByteBuffer currentBuffer = currentPooled.getResource();
        int remainingInBuffer = 0;
        if (this.getBuffer().remaining() > 0) {
            if (fcWindow > 0) {
                if (currentBuffer.remaining() < 8) {
                    currentPooled = (allHeaderBuffers = this.allocateAll(allHeaderBuffers, currentPooled)) == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
                    currentBuffer = currentPooled.getResource();
                }
                remainingInBuffer = this.getBuffer().remaining() - fcWindow;
                this.getBuffer().limit(this.getBuffer().position() + fcWindow);
                SpdyProtocolUtils.putInt(currentBuffer, this.getStreamId());
                SpdyProtocolUtils.putInt(currentBuffer, ((finalFrame ? 1 : 0) << 24) + fcWindow);
            } else {
                remainingInBuffer = this.getBuffer().remaining();
            }
        } else if (finalFrame && !firstFrame) {
            SpdyProtocolUtils.putInt(currentBuffer, this.getStreamId());
            SpdyProtocolUtils.putInt(currentBuffer, 0x1000000);
        }
        if (allHeaderBuffers == null) {
            currentBuffer.flip();
            return new SendFrameHeader(remainingInBuffer, currentPooled);
        }
        int length = 0;
        for (int i = 0; i < allHeaderBuffers.length; ++i) {
            length += allHeaderBuffers[i].getResource().position();
            allHeaderBuffers[i].getResource().flip();
        }
        try {
            ByteBuffer newBuf = ByteBuffer.allocate(length);
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                newBuf.put(allHeaderBuffers[i].getResource());
            }
            newBuf.flip();
            SendFrameHeader sendFrameHeader = new SendFrameHeader(remainingInBuffer, new ImmediatePooled<ByteBuffer>(newBuf));
            return sendFrameHeader;
        }
        finally {
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                allHeaderBuffers[i].free();
            }
        }
    }

    @Override
    protected Deflater getDeflater() {
        return this.deflater;
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        super.handleFlushComplete(finalFrame);
        if (finalFrame && this.completionListener != null) {
            ChannelListeners.invokeChannelListener(this, this.completionListener);
        }
    }

    public ChannelListener<SpdySynReplyStreamSinkChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<SpdySynReplyStreamSinkChannel> completionListener) {
        this.completionListener = completionListener;
    }
}

