/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.client.http2.Http2ClientExchange;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2PingStreamSourceChannel;
import io.undertow.protocols.http2.Http2RstStreamStreamSourceChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class Http2ClientConnection
implements ClientConnection {
    static final HttpString METHOD = new HttpString(":method");
    static final HttpString PATH = new HttpString(":path");
    static final HttpString SCHEME = new HttpString(":scheme");
    static final HttpString AUTHORITY = new HttpString(":authority");
    static final HttpString STATUS = new HttpString(":status");
    private final Http2Channel http2Channel;
    private final ChannelListener.SimpleSetter<ClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final Map<Integer, Http2ClientExchange> currentExchanges = new ConcurrentHashMap<Integer, Http2ClientExchange>();
    private boolean initialUpgradeRequest;

    public Http2ClientConnection(Http2Channel http2Channel, boolean initialUpgradeRequest) {
        this.http2Channel = http2Channel;
        http2Channel.getReceiveSetter().set(new Http2ReceiveListener());
        http2Channel.resumeReceives();
        http2Channel.addCloseTask(new ChannelListener<Http2Channel>(){

            @Override
            public void handleEvent(Http2Channel channel) {
                ChannelListeners.invokeChannelListener(Http2ClientConnection.this, Http2ClientConnection.this.closeSetter.get());
            }
        });
        this.initialUpgradeRequest = initialUpgradeRequest;
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        Http2HeadersStreamSinkChannel sinkChannel;
        Integer port;
        Boolean proto;
        request.getRequestHeaders().put(PATH, request.getPath());
        request.getRequestHeaders().put(SCHEME, "https");
        request.getRequestHeaders().put(AUTHORITY, request.getProtocol().toString());
        request.getRequestHeaders().put(METHOD, request.getMethod().toString());
        request.getRequestHeaders().put(AUTHORITY, request.getRequestHeaders().getFirst(Headers.HOST));
        request.getRequestHeaders().remove(Headers.HOST);
        boolean hasContent = true;
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (fixedLengthString != null) {
            try {
                long length = Long.parseLong(fixedLengthString);
                hasContent = length != 0L;
            }
            catch (NumberFormatException e) {
                this.handleError(new IOException(e));
                return;
            }
        } else if (transferEncodingString == null) {
            hasContent = false;
        }
        request.getRequestHeaders().remove(Headers.CONNECTION);
        request.getRequestHeaders().remove(Headers.KEEP_ALIVE);
        request.getRequestHeaders().remove(Headers.TRANSFER_ENCODING);
        String peer = request.getAttachment(ProxiedRequestAttachments.REMOTE_HOST);
        if (peer != null) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, peer);
        }
        if ((proto = request.getAttachment(ProxiedRequestAttachments.IS_SSL)) == null || !proto.booleanValue()) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_PROTO, "http");
        } else {
            request.getRequestHeaders().put(Headers.X_FORWARDED_PROTO, "https");
        }
        String hn = request.getAttachment(ProxiedRequestAttachments.SERVER_NAME);
        if (hn != null) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_HOST, hn);
        }
        if ((port = request.getAttachment(ProxiedRequestAttachments.SERVER_PORT)) != null) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_PORT, port.intValue());
        }
        try {
            sinkChannel = this.http2Channel.createStream(request.getRequestHeaders());
        }
        catch (IOException e) {
            clientCallback.failed(e);
            return;
        }
        Http2ClientExchange exchange = new Http2ClientExchange(this, sinkChannel, request);
        this.currentExchanges.put(sinkChannel.getStreamId(), exchange);
        if (clientCallback != null) {
            clientCallback.completed(exchange);
        }
        if (!hasContent) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    sinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<StreamSinkChannel>(){

                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            Http2ClientConnection.this.handleError(exception);
                        }
                    }));
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        } else if (!sinkChannel.isWriteResumed()) {
            try {
                if (!sinkChannel.flush()) {
                    sinkChannel.getWriteSetter().set(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            try {
                                if (channel.flush()) {
                                    channel.suspendWrites();
                                }
                            }
                            catch (IOException e) {
                                Http2ClientConnection.this.handleError(e);
                            }
                        }
                    });
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(IOException e) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose((Closeable)this);
        for (Map.Entry<Integer, Http2ClientExchange> entry : this.currentExchanges.entrySet()) {
            try {
                entry.getValue().failed(e);
            }
            catch (Exception ex) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
            }
        }
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.http2Channel.getBufferPool();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.http2Channel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.http2Channel.getPeerAddress(type);
    }

    @Override
    public ChannelListener.Setter<? extends ClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.http2Channel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.http2Channel.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.http2Channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.http2Channel.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.http2Channel.isOpen() && !this.http2Channel.isPeerGoneAway() && !this.http2Channel.isThisGoneAway();
    }

    @Override
    public void close() throws IOException {
        this.http2Channel.sendGoAway(0);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    @Override
    public boolean isUpgraded() {
        return false;
    }

    private class Http2ReceiveListener
    implements ChannelListener<Http2Channel> {
        private Http2ReceiveListener() {
        }

        @Override
        public void handleEvent(Http2Channel channel) {
            block12: {
                try {
                    AbstractHttp2StreamSourceChannel result = (AbstractHttp2StreamSourceChannel)channel.receive();
                    if (result instanceof Http2StreamSourceChannel) {
                        Http2ClientExchange request = (Http2ClientExchange)Http2ClientConnection.this.currentExchanges.remove(((Http2StreamSourceChannel)result).getStreamId());
                        if (request == null && Http2ClientConnection.this.initialUpgradeRequest) {
                            Channels.drain(result, Long.MAX_VALUE);
                            Http2ClientConnection.this.initialUpgradeRequest = false;
                            return;
                        }
                        if (request == null) {
                            IoUtils.safeClose((Closeable)channel);
                            return;
                        }
                        request.responseReady((Http2StreamSourceChannel)result);
                        break block12;
                    }
                    if (result instanceof Http2PingStreamSourceChannel) {
                        this.handlePing((Http2PingStreamSourceChannel)result);
                        break block12;
                    }
                    if (result instanceof Http2RstStreamStreamSourceChannel) {
                        int stream = ((Http2RstStreamStreamSourceChannel)result).getStreamId();
                        UndertowLogger.REQUEST_LOGGER.debugf("Client received RST_STREAM for stream %s", (Object)stream);
                        Http2ClientExchange exchange = (Http2ClientExchange)Http2ClientConnection.this.currentExchanges.get(stream);
                        if (exchange != null) {
                            exchange.failed(UndertowMessages.MESSAGES.http2StreamWasReset());
                        }
                        Channels.drain(result, Long.MAX_VALUE);
                        break block12;
                    }
                    if (!channel.isOpen()) {
                        throw UndertowMessages.MESSAGES.channelIsClosed();
                    }
                    if (result == null) break block12;
                    Channels.drain(result, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)Http2ClientConnection.this);
                    for (Map.Entry entry : Http2ClientConnection.this.currentExchanges.entrySet()) {
                        try {
                            ((Http2ClientExchange)entry.getValue()).failed(e);
                        }
                        catch (Exception ex) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
                        }
                    }
                }
            }
        }

        private void handlePing(Http2PingStreamSourceChannel frame) {
            byte[] id = frame.getData();
            if (!frame.isAck()) {
                frame.getHttp2Channel().sendPing(id);
            }
        }
    }
}

