/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowLogger;
import io.undertow.protocols.http2.AbstractHttp2StreamSinkChannel;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2StreamSinkChannel;
import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.server.protocol.framed.SendFrameHeader;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

class Http2FramePriority
implements FramePriority<Http2Channel, AbstractHttp2StreamSourceChannel, AbstractHttp2StreamSinkChannel> {
    public static Http2FramePriority INSTANCE = new Http2FramePriority();

    Http2FramePriority() {
    }

    @Override
    public boolean insertFrame(AbstractHttp2StreamSinkChannel newFrame, List<AbstractHttp2StreamSinkChannel> pendingFrames) {
        if (newFrame instanceof Http2StreamSinkChannel) {
            if (newFrame.isBroken()) {
                return true;
            }
            try {
                SendFrameHeader header = ((Http2StreamSinkChannel)newFrame).generateSendFrameHeader();
                if (header.getByteBuffer() == null) {
                    ((Http2StreamSinkChannel)newFrame).clearHeader();
                    return false;
                }
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.debugf("Failed to generate header %s", (Object)newFrame);
            }
        }
        pendingFrames.add(newFrame);
        return true;
    }

    @Override
    public void frameAdded(AbstractHttp2StreamSinkChannel addedFrame, List<AbstractHttp2StreamSinkChannel> pendingFrames, Deque<AbstractHttp2StreamSinkChannel> holdFrames) {
        Iterator<AbstractHttp2StreamSinkChannel> it = holdFrames.iterator();
        while (it.hasNext()) {
            AbstractHttp2StreamSinkChannel pending = it.next();
            if (!(pending instanceof Http2StreamSinkChannel)) continue;
            SendFrameHeader header = ((Http2StreamSinkChannel)pending).generateSendFrameHeader();
            if (header.getByteBuffer() != null) {
                pendingFrames.add(pending);
                it.remove();
                continue;
            }
            ((Http2StreamSinkChannel)pending).clearHeader();
        }
    }
}

