/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples;

import io.undertow.examples.UndertowExample;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xnio.IoUtils;

public class Runner {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        URL url = Runner.class.getClassLoader().getResource(Runner.class.getPackage().getName().replace(".", "/"));
        if (url == null) {
            throw new RuntimeException("Could not locate examples package");
        }
        HashMap examples = new HashMap();
        ZipInputStream in = null;
        try {
            Object example;
            String zipPath = url.getPath().substring(0, url.getPath().indexOf("!")).replace("file:", "");
            in = new ZipInputStream(new FileInputStream(zipPath));
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".class")) {
                    String className = entry.getName().substring(0, entry.getName().length() - 6).replace("/", ".");
                    try {
                        Class<?> clazz = Class.forName(className);
                        example = clazz.getAnnotation(UndertowExample.class);
                        if (example != null) {
                            examples.put(example.value(), clazz);
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                entry = in.getNextEntry();
            }
            ArrayList names = new ArrayList(examples.keySet());
            Collections.sort(names);
            System.out.println("Welcome to the Undertow Examples");
            System.out.println("Please select an example:");
            for (int i = 0; i < names.size(); ++i) {
                System.out.print((char)(97 + i));
                System.out.println(") " + (String)names.get(i));
            }
            byte[] data = new byte[1];
            System.in.read(data);
            example = (String)names.get(data[0] - 97);
            System.out.println("Running example " + (String)example);
            Class exampleClass = (Class)examples.get(example);
            UndertowExample annotation = exampleClass.getAnnotation(UndertowExample.class);
            System.out.println("Please point your web browser at " + annotation.location());
            Method main = exampleClass.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
                catch (NoSuchMethodException e2) {
                    throw new RuntimeException(e2);
                }
                catch (InvocationTargetException e3) {
                    throw new RuntimeException(e3);
                }
                catch (IllegalAccessException e4) {
                    throw new RuntimeException(e4);
                }
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(in);
                throw throwable;
            }
        }
        IoUtils.safeClose((Closeable)in);
    }
}

