/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.client.ALPNClientSelector;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientStatistics;
import io.undertow.client.spdy.SpdyClientConnection;
import io.undertow.conduits.ByteActivityCallback;
import io.undertow.conduits.BytesReceivedStreamSourceConduit;
import io.undertow.conduits.BytesSentStreamSinkConduit;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.server.DefaultByteBufferPool;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public class SpdyClientProvider
implements ClientProvider {
    public static final String SPDY_3 = "spdy/3";
    public static final String SPDY_3_1 = "spdy/3.1";
    private static final ChannelListener<SslConnection> FAILED = new ChannelListener<SslConnection>(){

        @Override
        public void handleEvent(SslConnection connection) {
            UndertowLogger.ROOT_LOGGER.alpnConnectionFailed(connection);
            IoUtils.safeClose((Closeable)connection);
        }
    };
    public static final DefaultByteBufferPool HEAP_BUFFER_POOL = new DefaultByteBufferPool(false, 8192);

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("spdy", "spdy-plain"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (uri.getScheme().equals("spdy-plain")) {
            if (bindAddress == null) {
                worker.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
            } else {
                worker.openStreamConnection(bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), null, options).addNotifier(this.createNotifier(listener), null);
            }
            return;
        }
        if (!ALPNClientSelector.isEnabled()) {
            listener.failed(UndertowMessages.MESSAGES.alpnNotAvailable());
            return;
        }
        if (ssl == null) {
            listener.failed(UndertowMessages.MESSAGES.sslWasNull());
            return;
        }
        OptionMap tlsOptions = OptionMap.builder().addAll(options).set(Options.SSL_STARTTLS, true).getMap();
        if (bindAddress == null) {
            ssl.openSslConnection(worker, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, tlsOptions), tlsOptions).addNotifier(this.createNotifier(listener), null);
        } else {
            ssl.openSslConnection(worker, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, tlsOptions), tlsOptions).addNotifier(this.createNotifier(listener), null);
        }
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (uri.getScheme().equals("spdy-plain")) {
            if (bindAddress == null) {
                ioThread.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
            } else {
                ioThread.openStreamConnection(bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), null, options).addNotifier(this.createNotifier(listener), null);
            }
            return;
        }
        if (!ALPNClientSelector.isEnabled()) {
            listener.failed(UndertowMessages.MESSAGES.alpnNotAvailable());
            return;
        }
        if (ssl == null) {
            listener.failed(UndertowMessages.MESSAGES.sslWasNull());
            return;
        }
        OptionMap tlsOptions = OptionMap.builder().addAll(options).set(Options.SSL_STARTTLS, true).getMap();
        if (bindAddress == null) {
            ssl.openSslConnection(ioThread, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, tlsOptions), tlsOptions).addNotifier(this.createNotifier(listener), null);
        } else {
            ssl.openSslConnection(ioThread, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, tlsOptions), tlsOptions).addNotifier(this.createNotifier(listener), null);
        }
    }

    private IoFuture.Notifier<StreamConnection, Object> createNotifier(final ClientCallback<ClientConnection> listener) {
        return new IoFuture.Notifier<StreamConnection, Object>(){

            @Override
            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
    }

    private ChannelListener<StreamConnection> createOpenListener(final ClientCallback<ClientConnection> listener, final URI uri, final XnioSsl ssl, final ByteBufferPool bufferPool, final OptionMap options) {
        return new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                SpdyClientProvider.this.handleConnected(connection, listener, uri, ssl, bufferPool, options);
            }
        };
    }

    private void handleConnected(StreamConnection connection, ClientCallback<ClientConnection> listener, URI uri, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (connection instanceof SslConnection) {
            ALPNClientSelector.runAlpn((SslConnection)connection, FAILED, listener, SpdyClientProvider.alpnProtocol(listener, uri, bufferPool, options, SPDY_3_1), SpdyClientProvider.alpnProtocol(listener, uri, bufferPool, options, SPDY_3));
        } else {
            listener.completed(SpdyClientProvider.createSpdyChannel(connection, bufferPool, options));
        }
    }

    public static ALPNClientSelector.ALPNProtocol alpnProtocol(final ClientCallback<ClientConnection> listener, URI uri, final ByteBufferPool bufferPool, final OptionMap options, String protocol) {
        return new ALPNClientSelector.ALPNProtocol(new ChannelListener<SslConnection>(){

            @Override
            public void handleEvent(SslConnection connection) {
                listener.completed(SpdyClientProvider.createSpdyChannel(connection, bufferPool, options));
            }
        }, protocol);
    }

    private static SpdyClientConnection createSpdyChannel(StreamConnection connection, ByteBufferPool bufferPool, OptionMap options) {
        ClientStatisticsImpl clientStatistics;
        if (options.get(UndertowOptions.ENABLE_STATISTICS, false)) {
            clientStatistics = new ClientStatisticsImpl();
            connection.getSinkChannel().setConduit(new BytesSentStreamSinkConduit(connection.getSinkChannel().getConduit(), new ByteActivityCallback(){

                @Override
                public void activity(long bytes) {
                    clientStatistics.written = clientStatistics.written + bytes;
                }
            }));
            connection.getSourceChannel().setConduit(new BytesReceivedStreamSourceConduit(connection.getSourceChannel().getConduit(), new ByteActivityCallback(){

                @Override
                public void activity(long bytes) {
                    clientStatistics.read = clientStatistics.read + bytes;
                }
            }));
        } else {
            clientStatistics = null;
        }
        SpdyChannel spdyChannel = new SpdyChannel(connection, bufferPool, null, HEAP_BUFFER_POOL, true, options);
        return new SpdyClientConnection(spdyChannel, clientStatistics);
    }

    private static class ClientStatisticsImpl
    implements ClientStatistics {
        private long requestCount;
        private long read;
        private long written;

        private ClientStatisticsImpl() {
        }

        @Override
        public long getRequests() {
            return this.requestCount;
        }

        @Override
        public long getRead() {
            return this.read;
        }

        @Override
        public long getWritten() {
            return this.written;
        }

        @Override
        public void reset() {
            this.read = 0L;
            this.written = 0L;
            this.requestCount = 0L;
        }
    }
}

