/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ChunkReader;
import io.undertow.conduits.ConduitListener;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.PooledAdaptor;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public class ChunkedStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    @Deprecated
    public static final AttachmentKey<HeaderMap> TRAILERS = HttpAttachments.REQUEST_TRAILERS;
    private final BufferWrapper bufferWrapper;
    private final ConduitListener<? super ChunkedStreamSourceConduit> finishListener;
    private final HttpServerExchange exchange;
    private boolean closed;
    private long remainingAllowed;
    private final ChunkReader chunkReader;

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final PushBackStreamSourceConduit channel, final ByteBufferPool pool, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, Attachable attachable) {
        this(next, new BufferWrapper(){

            @Override
            public PooledByteBuffer allocate() {
                return pool.allocate();
            }

            @Override
            public void pushBack(PooledByteBuffer pooled) {
                channel.pushBack(new PooledAdaptor(pooled));
            }
        }, finishListener, attachable, null);
    }

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final HttpServerExchange exchange, ConduitListener<? super ChunkedStreamSourceConduit> finishListener) {
        this(next, new BufferWrapper(){

            @Override
            public PooledByteBuffer allocate() {
                return exchange.getConnection().getByteBufferPool().allocate();
            }

            @Override
            public void pushBack(PooledByteBuffer pooled) {
                ((HttpServerConnection)exchange.getConnection()).ungetRequestBytes(pooled);
            }
        }, finishListener, exchange, exchange);
    }

    protected ChunkedStreamSourceConduit(StreamSourceConduit next, BufferWrapper bufferWrapper, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, Attachable attachable, HttpServerExchange exchange) {
        super(next);
        this.bufferWrapper = bufferWrapper;
        this.finishListener = finishListener;
        this.remainingAllowed = Long.MIN_VALUE;
        this.chunkReader = new ChunkReader<ChunkedStreamSourceConduit>(attachable, HttpAttachments.REQUEST_TRAILERS, finishListener, this);
        this.exchange = exchange;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        try {
            return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
        }
        catch (IOException | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
    }

    private void updateRemainingAllowed(int written) throws IOException {
        if (this.remainingAllowed == Long.MIN_VALUE) {
            if (this.exchange == null) {
                return;
            }
            long maxEntitySize = this.exchange.getMaxEntitySize();
            if (maxEntitySize <= 0L) {
                return;
            }
            this.remainingAllowed = maxEntitySize;
        }
        this.remainingAllowed -= (long)written;
        if (this.remainingAllowed < 0L) {
            Connectors.terminateRequest(this.exchange);
            this.closed = true;
            this.exchange.setPersistent(false);
            this.finishListener.handleEvent(this);
            throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(this.exchange.getMaxEntitySize());
        }
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        try {
            return IoUtils.transfer(new ConduitReadableByteChannel(this), count, throughBuffer, target);
        }
        catch (IOException | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    @Override
    public void terminateReads() throws IOException {
        if (!this.isFinished()) {
            this.exchange.setPersistent(false);
            super.terminateReads();
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        try {
            long chunkRemaining = this.chunkReader.getChunkRemaining();
            if (chunkRemaining == -1L) {
                return -1;
            }
            if (this.closed) {
                throw new ClosedChannelException();
            }
            PooledByteBuffer pooled = this.bufferWrapper.allocate();
            ByteBuffer buf = pooled.getBuffer();
            boolean free = true;
            try {
                int n;
                long chunkInBuffer;
                int read;
                int originalLimit;
                block32: {
                    int r = ((StreamSourceConduit)this.next).read(buf);
                    buf.flip();
                    if (r == -1) {
                        throw new ClosedChannelException();
                    }
                    if (r == 0) {
                        int n2 = 0;
                        return n2;
                    }
                    if (chunkRemaining == 0L && (chunkRemaining = this.chunkReader.readChunk(buf)) <= 0L) {
                        if (buf.hasRemaining()) {
                            free = false;
                        }
                        int n3 = (int)chunkRemaining;
                        return n3;
                    }
                    originalLimit = dst.limit();
                    read = 0;
                    chunkInBuffer = Math.min((long)buf.remaining(), chunkRemaining);
                    int remaining = dst.remaining();
                    if (chunkInBuffer <= (long)remaining) break block32;
                    int orig = buf.limit();
                    buf.limit(buf.position() + remaining);
                    dst.put(buf);
                    buf.limit(orig);
                    chunkRemaining -= (long)remaining;
                    this.updateRemainingAllowed(remaining);
                    free = false;
                    int n4 = remaining;
                    dst.limit(originalLimit);
                    return n4;
                }
                try {
                    block34: {
                        int old;
                        if (buf.hasRemaining()) {
                            old = buf.limit();
                            buf.limit((int)Math.min((long)old, (long)buf.position() + chunkInBuffer));
                            try {
                                dst.put(buf);
                            }
                            finally {
                                buf.limit(old);
                            }
                            read = (int)((long)read + chunkInBuffer);
                            chunkRemaining -= chunkInBuffer;
                        }
                        if (chunkRemaining > 0L) {
                            old = dst.limit();
                            try {
                                if (chunkRemaining < (long)dst.remaining()) {
                                    dst.limit((int)((long)dst.position() + chunkRemaining));
                                }
                                int c = 0;
                                do {
                                    if ((c = ((StreamSourceConduit)this.next).read(dst)) <= 0) continue;
                                    read += c;
                                    chunkRemaining -= (long)c;
                                } while (c > 0 && chunkRemaining > 0L);
                                if (c == -1) {
                                    throw new ClosedChannelException();
                                }
                                break block34;
                            }
                            finally {
                                dst.limit(old);
                            }
                        }
                        free = false;
                    }
                    this.updateRemainingAllowed(read);
                    n = read;
                    dst.limit(originalLimit);
                }
                catch (Throwable throwable) {
                    dst.limit(originalLimit);
                    throw throwable;
                }
                return n;
            }
            finally {
                if (chunkRemaining >= 0L) {
                    this.chunkReader.setChunkRemaining(chunkRemaining);
                }
                if (!free && buf.hasRemaining()) {
                    this.bufferWrapper.pushBack(pooled);
                } else {
                    pooled.close();
                }
            }
        }
        catch (IOException | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
    }

    public boolean isFinished() {
        return this.closed || this.chunkReader.getChunkRemaining() == -1L;
    }

    static interface BufferWrapper {
        public PooledByteBuffer allocate();

        public void pushBack(PooledByteBuffer var1);
    }
}

