/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.VirtualHost;

public interface ModClusterProxyTarget
extends ProxyClient.ProxyTarget {
    public Context resolveContext(HttpServerExchange var1);

    public static class BasicTarget
    implements ModClusterProxyTarget {
        private final VirtualHost.HostEntry entry;
        private final ModClusterContainer container;

        public BasicTarget(VirtualHost.HostEntry entry, ModClusterContainer container) {
            this.entry = entry;
            this.container = container;
        }

        @Override
        public Context resolveContext(HttpServerExchange exchange) {
            return this.container.findNewNode(this.entry);
        }
    }

    public static class ExistingSessionTarget
    implements ModClusterProxyTarget {
        private final String session;
        private final String jvmRoute;
        private final VirtualHost.HostEntry entry;
        private final boolean forceStickySession;
        private final ModClusterContainer container;
        private Context resolved;

        public ExistingSessionTarget(String session, String jvmRoute, VirtualHost.HostEntry entry, ModClusterContainer container, boolean forceStickySession) {
            this.session = session;
            this.jvmRoute = jvmRoute;
            this.entry = entry;
            this.container = container;
            this.forceStickySession = forceStickySession;
        }

        @Override
        public Context resolveContext(HttpServerExchange exchange) {
            if (this.resolved == null) {
                this.resolveNode();
            }
            return this.resolved;
        }

        void resolveNode() {
            Context context = this.entry.getContextForNode(this.jvmRoute);
            if (context != null && context.checkAvailable(true)) {
                Node node = context.getNode();
                node.elected();
                this.resolved = context;
                return;
            }
            String domain = context != null ? context.getNode().getNodeConfig().getDomain() : null;
            this.resolved = this.container.findFailoverNode(this.entry, domain, this.session, this.jvmRoute, this.forceStickySession);
        }
    }
}

