/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.SavedRequest;
import java.security.AccessController;

public class CachedAuthenticatedSessionHandler
implements HttpHandler {
    public static final String ATTRIBUTE_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    public static final String NO_ID_CHANGE_REQUIRED = CachedAuthenticatedSessionHandler.class.getName() + ".NoIdChangeRequired";
    private final NotificationReceiver NOTIFICATION_RECEIVER = new SecurityNotificationReceiver();
    private final AuthenticatedSessionManager SESSION_MANAGER = new ServletAuthenticatedSessionManager();
    private final HttpHandler next;
    private final ServletContextImpl servletContext;

    public CachedAuthenticatedSessionHandler(HttpHandler next, ServletContextImpl servletContext) {
        this.next = next;
        this.servletContext = servletContext;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext securityContext = exchange.getSecurityContext();
        securityContext.registerNotificationReceiver(this.NOTIFICATION_RECEIVER);
        HttpSessionImpl session = this.servletContext.getSession(exchange, false);
        if (session != null) {
            exchange.putAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY, this.SESSION_MANAGER);
            SavedRequest.tryRestoreRequest(exchange, session);
        }
        this.next.handleRequest(exchange);
    }

    protected Session underlyingSession(HttpSessionImpl httpSession) {
        Session session = System.getSecurityManager() == null ? httpSession.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(httpSession));
        return session;
    }

    private boolean isCacheable(SecurityNotification notification) {
        return notification.isProgramatic() || notification.isCachingRequired();
    }

    private class ServletAuthenticatedSessionManager
    implements AuthenticatedSessionManager {
        private ServletAuthenticatedSessionManager() {
        }

        @Override
        public AuthenticatedSessionManager.AuthenticatedSession lookupSession(HttpServerExchange exchange) {
            HttpSessionImpl httpSession = CachedAuthenticatedSessionHandler.this.servletContext.getSession(exchange, false);
            if (httpSession != null) {
                Session session = CachedAuthenticatedSessionHandler.this.underlyingSession(httpSession);
                return (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(ATTRIBUTE_NAME);
            }
            return null;
        }

        @Override
        public void clearSession(HttpServerExchange exchange) {
            HttpSessionImpl httpSession = CachedAuthenticatedSessionHandler.this.servletContext.getSession(exchange, false);
            if (httpSession != null) {
                Session session = CachedAuthenticatedSessionHandler.this.underlyingSession(httpSession);
                session.removeAttribute(ATTRIBUTE_NAME);
            }
        }
    }

    private class SecurityNotificationReceiver
    implements NotificationReceiver {
        private SecurityNotificationReceiver() {
        }

        @Override
        public void handleNotification(SecurityNotification notification) {
            SecurityNotification.EventType eventType = notification.getEventType();
            HttpSessionImpl httpSession = CachedAuthenticatedSessionHandler.this.servletContext.getSession(notification.getExchange(), false);
            switch (eventType) {
                case AUTHENTICATED: {
                    Session session;
                    if (CachedAuthenticatedSessionHandler.this.servletContext.getDeployment().getDeploymentInfo().isChangeSessionIdOnLogin() && httpSession != null) {
                        session = CachedAuthenticatedSessionHandler.this.underlyingSession(httpSession);
                        if (!httpSession.isNew() && !httpSession.isInvalid() && session.getAttribute(NO_ID_CHANGE_REQUIRED) == null) {
                            ServletRequestContext src = notification.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                            src.getOriginalRequest().changeSessionId();
                        }
                        session.setAttribute(NO_ID_CHANGE_REQUIRED, true);
                    }
                    if (!CachedAuthenticatedSessionHandler.this.isCacheable(notification)) break;
                    if (httpSession == null) {
                        httpSession = CachedAuthenticatedSessionHandler.this.servletContext.getSession(notification.getExchange(), true);
                    }
                    session = CachedAuthenticatedSessionHandler.this.underlyingSession(httpSession);
                    session.setAttribute(ATTRIBUTE_NAME, new AuthenticatedSessionManager.AuthenticatedSession(notification.getAccount(), notification.getMechanism()));
                    break;
                }
                case LOGGED_OUT: {
                    if (httpSession == null) break;
                    Session session = CachedAuthenticatedSessionHandler.this.underlyingSession(httpSession);
                    session.removeAttribute(ATTRIBUTE_NAME);
                    session.removeAttribute(NO_ID_CHANGE_REQUIRED);
                }
            }
        }
    }
}

