/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ClosedWorkerException;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.management.XnioWorkerMXBean;
import org.xnio.nio.Log;
import org.xnio.nio.NioUdpChannel;
import org.xnio.nio.NioXnio;
import org.xnio.nio.QueuedNioTcpServer;
import org.xnio.nio.WorkerThread;

final class NioXnioWorker
extends XnioWorker {
    private static final int CLOSE_REQ = Integer.MIN_VALUE;
    private static final int CLOSE_COMP = 0x40000000;
    private volatile int state = 1;
    private final WorkerThread[] workerThreads;
    private final WorkerThread acceptThread;
    private final Closeable mbeanHandle;
    private volatile Thread shutdownWaiter;
    private static final AtomicReferenceFieldUpdater<NioXnioWorker, Thread> shutdownWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(NioXnioWorker.class, Thread.class, "shutdownWaiter");
    private static final AtomicIntegerFieldUpdater<NioXnioWorker> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NioXnioWorker.class, "state");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioXnioWorker(NioXnio xnio, ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException {
        super(xnio, threadGroup, optionMap, terminationTask);
        final int threadCount = optionMap.contains(Options.WORKER_IO_THREADS) ? optionMap.get(Options.WORKER_IO_THREADS, 0) : Math.max(optionMap.get(Options.WORKER_READ_THREADS, 1), optionMap.get(Options.WORKER_WRITE_THREADS, 1));
        if (threadCount < 0) {
            throw Log.log.optionOutOfRange("WORKER_IO_THREADS");
        }
        long workerStackSize = optionMap.get(Options.STACK_SIZE, 0L);
        if (workerStackSize < 0L) {
            throw Log.log.optionOutOfRange("STACK_SIZE");
        }
        final String workerName = this.getName();
        WorkerThread[] workerThreads = new WorkerThread[threadCount];
        boolean markWorkerThreadAsDaemon = optionMap.get(Options.THREAD_DAEMON, false);
        boolean ok = false;
        try {
            for (int i = 0; i < threadCount; ++i) {
                WorkerThread workerThread = new WorkerThread(this, xnio.mainSelectorCreator.open(), String.format("%s I/O-%d", workerName, i + 1), threadGroup, workerStackSize, i);
                if (markWorkerThreadAsDaemon) {
                    workerThread.setDaemon(true);
                }
                workerThreads[i] = workerThread;
            }
            this.acceptThread = new WorkerThread(this, xnio.mainSelectorCreator.open(), String.format("%s Accept", workerName), threadGroup, workerStackSize, threadCount);
            if (markWorkerThreadAsDaemon) {
                this.acceptThread.setDaemon(true);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WorkerThread worker : workerThreads) {
                    if (worker == null) continue;
                    IoUtils.safeClose(worker.getSelector());
                }
            }
        }
        this.workerThreads = workerThreads;
        this.mbeanHandle = NioXnio.register(new XnioWorkerMXBean(){

            @Override
            public String getProviderName() {
                return "nio";
            }

            @Override
            public String getName() {
                return workerName;
            }

            @Override
            public boolean isShutdownRequested() {
                return NioXnioWorker.this.isShutdown();
            }

            @Override
            public int getCoreWorkerPoolSize() {
                return NioXnioWorker.this.getCoreWorkerPoolSize();
            }

            @Override
            public int getMaxWorkerPoolSize() {
                return NioXnioWorker.this.getMaxWorkerPoolSize();
            }

            @Override
            public int getIoThreadCount() {
                return threadCount;
            }

            @Override
            public int getWorkerQueueSize() {
                return NioXnioWorker.this.getWorkerQueueSize();
            }
        });
    }

    void start() {
        for (WorkerThread worker : this.workerThreads) {
            this.openResourceUnconditionally();
            worker.start();
        }
        this.openResourceUnconditionally();
        this.acceptThread.start();
    }

    @Override
    protected WorkerThread chooseThread() {
        return this.getIoThread(ThreadLocalRandom.current().nextInt());
    }

    @Override
    public WorkerThread getIoThread(int hashCode) {
        WorkerThread[] workerThreads = this.workerThreads;
        int length = workerThreads.length;
        if (length == 0) {
            throw Log.log.noThreads();
        }
        if (length == 1) {
            return workerThreads[0];
        }
        return workerThreads[Math.floorMod(hashCode, length)];
    }

    @Override
    public int getIoThreadCount() {
        return this.workerThreads.length;
    }

    WorkerThread[] getAll() {
        return this.workerThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AcceptingChannel<StreamConnection> createTcpConnectionServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<StreamConnection>> acceptListener, OptionMap optionMap) throws IOException {
        this.checkShutdown();
        boolean ok = false;
        ServerSocketChannel channel = ServerSocketChannel.open();
        try {
            if (optionMap.contains(Options.RECEIVE_BUFFER)) {
                channel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
            }
            channel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
            channel.configureBlocking(false);
            if (optionMap.contains(Options.BACKLOG)) {
                channel.socket().bind(bindAddress, optionMap.get(Options.BACKLOG, 128));
            } else {
                channel.socket().bind(bindAddress);
            }
            QueuedNioTcpServer server = new QueuedNioTcpServer(this, channel, optionMap);
            server.setAcceptListener((ChannelListener<? super QueuedNioTcpServer>)acceptListener);
            ok = true;
            QueuedNioTcpServer queuedNioTcpServer = server;
            return queuedNioTcpServer;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    @Override
    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        InetAddress address;
        this.checkShutdown();
        DatagramChannel channel = NioXnio.NIO2 && bindAddress != null ? ((address = bindAddress.getAddress()) instanceof Inet6Address ? DatagramChannel.open(StandardProtocolFamily.INET6) : DatagramChannel.open(StandardProtocolFamily.INET)) : DatagramChannel.open();
        channel.configureBlocking(false);
        if (optionMap.contains(Options.BROADCAST)) {
            channel.socket().setBroadcast(optionMap.get(Options.BROADCAST, false));
        }
        if (optionMap.contains(Options.IP_TRAFFIC_CLASS)) {
            channel.socket().setTrafficClass(optionMap.get(Options.IP_TRAFFIC_CLASS, -1));
        }
        if (optionMap.contains(Options.RECEIVE_BUFFER)) {
            channel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
        }
        channel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
        if (optionMap.contains(Options.SEND_BUFFER)) {
            channel.socket().setSendBufferSize(optionMap.get(Options.SEND_BUFFER, -1));
        }
        channel.socket().bind(bindAddress);
        NioUdpChannel udpChannel = new NioUdpChannel(this, channel);
        ChannelListeners.invokeChannelListener(udpChannel, bindListener);
        return udpChannel;
    }

    @Override
    public boolean isShutdown() {
        return (this.state & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean isTerminated() {
        return (this.state & 0x40000000) != 0;
    }

    void openResourceUnconditionally() {
        int oldState = stateUpdater.getAndIncrement(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)oldState, (Object)(oldState + 1));
        }
    }

    void checkShutdown() throws ClosedWorkerException {
        if (this.isShutdown()) {
            throw Log.log.workerShutDown();
        }
    }

    void closeResource() {
        int oldState = stateUpdater.decrementAndGet(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)(oldState + 1), (Object)oldState);
        }
        while (oldState == Integer.MIN_VALUE) {
            if (stateUpdater.compareAndSet(this, Integer.MIN_VALUE, -1073741824)) {
                Log.log.tracef("CAS %s %08x -> %08x (close complete)", (Object)this, (Object)Integer.MIN_VALUE, (Object)-1073741824);
                NioXnioWorker.safeUnpark(shutdownWaiterUpdater.getAndSet(this, null));
                Runnable task = this.getTerminationTask();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            oldState = this.state;
        }
    }

    @Override
    public void shutdown() {
        int oldState = this.state;
        while ((oldState & Integer.MIN_VALUE) == 0) {
            if (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE)) {
                oldState = this.state;
                continue;
            }
            Log.log.tracef("Initiating shutdown of %s", (Object)this);
            for (WorkerThread worker : this.workerThreads) {
                worker.shutdown();
            }
            this.acceptThread.shutdown();
            this.shutDownTaskPool();
            return;
        }
        Log.log.tracef("Idempotent shutdown of %s", (Object)this);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.shutDownTaskPoolNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet(oldState, 0x40000000)) {
            return true;
        }
        long then = System.nanoTime();
        long duration = unit.toNanos(timeout);
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear(oldState = this.state, 0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                oldState = this.state;
                if (Bits.allAreSet(oldState, 0x40000000)) break;
                LockSupport.parkNanos(this, duration);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long now = System.nanoTime();
                if ((duration -= now - then) >= 0L) continue;
                oldState = this.state;
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
        return Bits.allAreSet(oldState, 0x40000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitTermination() throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet(oldState, 0x40000000)) {
            return;
        }
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear(this.state, 0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                if (!Bits.allAreSet(this.state, 0x40000000)) {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
    }

    private static void safeUnpark(Thread waiter) {
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    @Override
    protected void taskPoolTerminated() {
        IoUtils.safeClose(this.mbeanHandle);
        this.closeResource();
    }

    @Override
    public NioXnio getXnio() {
        return (NioXnio)super.getXnio();
    }

    WorkerThread getAcceptThread() {
        return this.acceptThread;
    }
}

