/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2HeaderBlockParser;
import java.nio.ByteBuffer;
import org.xnio.Bits;

class Http2HeadersParser
extends Http2HeaderBlockParser {
    private static final int DEPENDENCY_MASK = -129;
    private int paddingLength = 0;
    private int dependentStreamId = 0;
    private int weight = 16;
    private boolean headersEndStream = false;
    private boolean exclusive;

    Http2HeadersParser(int frameLength, HpackDecoder hpackDecoder) {
        super(frameLength, hpackDecoder);
    }

    @Override
    protected boolean handleBeforeHeader(ByteBuffer resource, Http2FrameHeaderParser headerParser) {
        boolean hasPadding = Bits.anyAreSet(headerParser.flags, 8);
        boolean hasPriority = Bits.anyAreSet(headerParser.flags, 32);
        this.headersEndStream = Bits.allAreSet(headerParser.flags, 1);
        int reqLength = (hasPadding ? 1 : 0) + (hasPriority ? 5 : 0);
        if (reqLength == 0) {
            return true;
        }
        if (resource.remaining() < reqLength) {
            return false;
        }
        if (hasPadding) {
            this.paddingLength = resource.get() & 0xFF;
        }
        if (hasPriority) {
            if (resource.remaining() < 4) {
                return false;
            }
            byte b = resource.get();
            this.exclusive = (b & 0x80) != 0;
            this.dependentStreamId = (b & 0xFFFFFF7F & 0xFF) << 24;
            this.dependentStreamId += (resource.get() & 0xFF) << 16;
            this.dependentStreamId += (resource.get() & 0xFF) << 8;
            this.dependentStreamId += resource.get() & 0xFF;
            this.weight = resource.get() & 0xFF;
        }
        return true;
    }

    int getPaddingLength() {
        return this.paddingLength;
    }

    int getDependentStreamId() {
        return this.dependentStreamId;
    }

    int getWeight() {
        return this.weight;
    }

    boolean isHeadersEndStream() {
        return this.headersEndStream;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }
}

