/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.spec.ServletPrintWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import sun.misc.Unsafe;

public final class ServletPrintWriterDelegate
extends PrintWriter {
    private static final Unsafe UNSAFE = ServletPrintWriterDelegate.getUnsafe();
    private ServletPrintWriter servletPrintWriter;

    private ServletPrintWriterDelegate() {
        super((OutputStream)null);
    }

    public static ServletPrintWriterDelegate newInstance(ServletPrintWriter servletPrintWriter) {
        ServletPrintWriterDelegate delegate;
        if (System.getSecurityManager() == null) {
            try {
                delegate = (ServletPrintWriterDelegate)UNSAFE.allocateInstance(ServletPrintWriterDelegate.class);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        } else {
            delegate = AccessController.doPrivileged(new PrivilegedAction<ServletPrintWriterDelegate>(){

                @Override
                public ServletPrintWriterDelegate run() {
                    try {
                        return (ServletPrintWriterDelegate)UNSAFE.allocateInstance(ServletPrintWriterDelegate.class);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        delegate.setServletPrintWriter(servletPrintWriter);
        return delegate;
    }

    public void setServletPrintWriter(ServletPrintWriter servletPrintWriter) {
        this.servletPrintWriter = servletPrintWriter;
    }

    @Override
    public void flush() {
        this.servletPrintWriter.flush();
    }

    @Override
    public void close() {
        this.servletPrintWriter.close();
    }

    @Override
    public boolean checkError() {
        return this.servletPrintWriter.checkError();
    }

    @Override
    public void write(int c) {
        this.servletPrintWriter.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.servletPrintWriter.write(buf, off, len);
    }

    @Override
    public void write(char[] buf) {
        this.servletPrintWriter.write(buf);
    }

    @Override
    public void write(String s, int off, int len) {
        this.servletPrintWriter.write(s, off, len);
    }

    @Override
    public void write(String s) {
        this.servletPrintWriter.write(s == null ? "null" : s);
    }

    @Override
    public void print(boolean b) {
        this.servletPrintWriter.print(b);
    }

    @Override
    public void print(char c) {
        this.servletPrintWriter.print(c);
    }

    @Override
    public void print(int i) {
        this.servletPrintWriter.print(i);
    }

    @Override
    public void print(long l) {
        this.servletPrintWriter.print(l);
    }

    @Override
    public void print(float f) {
        this.servletPrintWriter.print(f);
    }

    @Override
    public void print(double d) {
        this.servletPrintWriter.print(d);
    }

    @Override
    public void print(char[] s) {
        this.servletPrintWriter.print(s);
    }

    @Override
    public void print(String s) {
        this.servletPrintWriter.print(s);
    }

    @Override
    public void print(Object obj) {
        this.servletPrintWriter.print(obj);
    }

    @Override
    public void println() {
        this.servletPrintWriter.println();
    }

    @Override
    public void println(boolean x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(char x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(int x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(long x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(float x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(double x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(char[] x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(String x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(Object x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        this.servletPrintWriter.printf(format, args);
        return this;
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        this.servletPrintWriter.printf(l, format, args);
        return this;
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        this.servletPrintWriter.format(format, args);
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        this.servletPrintWriter.format(l, format, args);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.servletPrintWriter.append(csq);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.servletPrintWriter.append(csq, start, end);
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        this.servletPrintWriter.append(c);
        return this;
    }

    private static Unsafe getUnsafe() {
        if (System.getSecurityManager() != null) {
            return new PrivilegedAction<Unsafe>(){

                @Override
                public Unsafe run() {
                    return ServletPrintWriterDelegate.getUnsafe0();
                }
            }.run();
        }
        return ServletPrintWriterDelegate.getUnsafe0();
    }

    private static Unsafe getUnsafe0() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException("JDK did not allow accessing unsafe", t);
        }
    }
}

