/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.jakartaee9;

import io.undertow.jakartaee9.ArtifactNameTransformer;
import io.undertow.jakartaee9.PomTransformer;
import io.undertow.jakartaee9.TransformConstants;
import io.undertow.jakartaee9.UndertowJakartaEE9Logger;
import java.io.File;
import java.io.IOException;
import org.wildfly.transformer.tool.api.ToolUtils;

public class JakartaEE9Transformer {
    public static void main(String[] args) throws IOException {
        UndertowJakartaEE9Logger.LOGGER.greeting(TransformConstants.VERSION_STRING);
        UndertowJakartaEE9Logger.LOGGER.transformationInfo("jakarta.servlet", "jakarta.servlet-api", TransformConstants.SERVLET_SPEC_VERSION, "jakarta.websocket", "jakarta.websocket-client-api", TransformConstants.WEBSOCKETS_SPEC_VERSION);
        PomTransformer pomTransformer = new PomTransformer(TransformConstants.INPUT_DIR, TransformConstants.OUTPUT_DIR);
        pomTransformer.transformPoms();
        for (File file : TransformConstants.INPUT_DIR.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            String newFileName = ArtifactNameTransformer.transformArtifactFileName(file.getName(), "jar");
            UndertowJakartaEE9Logger.LOGGER.transformingFile(file.getName(), newFileName);
            ToolUtils.transformJarFile((File)file, (File)TransformConstants.OUTPUT_DIR, null);
            File generatedFile = new File(TransformConstants.OUTPUT_DIR.getAbsolutePath() + File.separatorChar + file.getName());
            assert (generatedFile.exists());
            generatedFile.renameTo(new File(TransformConstants.OUTPUT_DIR.getAbsolutePath() + File.separatorChar + newFileName));
        }
    }
}

