/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.jakartaee9;

import io.undertow.jakartaee9.ArtifactNameTransformer;
import io.undertow.jakartaee9.TransformConstants;
import io.undertow.jakartaee9.UndertowJakartaEE9Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

class PomTransformer {
    private static final String VERSION_LINE = "\\s*<version>.*</version>\\s*";
    private static final String OPEN_ARTIFACT = "<artifactId>";
    private static final String CLOSE_ARTIFACT = "</artifactId>";
    private static final String SERVLET_SPEC_JAKARTAEE8_ARTIFACT_LINE = "<artifactId>jboss-servlet-api_4.0_spec</artifactId>";
    private static final String SERVLET_SPEC_JAKARTAEE9_ARTIFACT_LINE = "<artifactId>jakarta.servlet-api</artifactId>";
    private static final String WEBSOCKETS_SPEC_JAKARTAEE8_ARTIFACT_LINE = "<artifactId>jboss-websocket-api_1.1_spec</artifactId>";
    private static final String WEBSOCKETS_SPEC_JAKARTAEE9_ARTIFACT_LINE = "<artifactId>jakarta.websocket-client-api</artifactId>";
    private static final String OPEN_GROUP = "<groupId>";
    private static final String CLOSE_GROUP = "</groupId>";
    private static final String SERVLET_SPEC_JAKARTAEE8_GROUP_LINE = "<groupId>org.jboss.spec.javax.servlet</groupId>";
    private static final String SERVLET_SPEC_JAKARTAEE9_GROUP_LINE = "<groupId>jakarta.servlet</groupId>";
    private static final String WEBSOCKETS_SPEC_JAKARTAEE8_GROUP_LINE = "<groupId>org.jboss.spec.javax.websocket</groupId>";
    private static final String WEBSOCKETS_SPEC_JAKARTAEE9_GROUP_LINE = "<groupId>jakarta.websocket</groupId>";
    private static final String OPEN_VERSION = "<version>";
    private static final String CLOSE_VERSION = "</version>";
    private static final String SERVLET_SPEC_VERSION_LINE = "<version>" + TransformConstants.SERVLET_SPEC_VERSION + "</version>";
    private static final String WEBSOCKETS_SPEC_VERSION_LINE = "<version>" + TransformConstants.WEBSOCKETS_SPEC_VERSION + "</version>";
    private final File inputDir;
    private final File outputDir;
    private boolean skipVersion;

    PomTransformer(File inputDir, File outputDir) {
        this.inputDir = inputDir;
        this.outputDir = outputDir;
    }

    void transformPoms() throws IOException {
        HashMap<String, String> artifactMapping = new HashMap<String, String>();
        Stream<Path> paths = Files.walk(this.inputDir.toPath(), new FileVisitOption[0]);
        paths.forEach(p -> {
            String fileName = p.getFileName().toString();
            if (fileName.endsWith(".pom")) {
                artifactMapping.put(ArtifactNameTransformer.getArtifactName(fileName, "pom"), ArtifactNameTransformer.transformArtifactName(fileName, "pom"));
            }
        });
        for (File file : this.inputDir.listFiles()) {
            if (!file.getName().endsWith(".pom")) continue;
            this.transformPom(file, artifactMapping);
        }
    }

    private void transformPom(File pomFile, Map<String, String> artifactMapping) throws IOException {
        String pomFileName = pomFile.getName();
        String transformedPomFileName = ArtifactNameTransformer.transformArtifactFileName(pomFileName, "pom");
        File transformedPomFile = new File(this.outputDir, transformedPomFileName);
        transformedPomFile.createNewFile();
        UndertowJakartaEE9Logger.LOGGER.transformingFile(pomFileName, transformedPomFileName);
        Stream<String> pomLines = Files.lines(pomFile.toPath());
        Stream<String> transformedPomLines = pomLines.map(line -> this.transformPomLine((String)line, artifactMapping));
        FileWriter fileWriter = new FileWriter(transformedPomFile);
        transformedPomLines.forEachOrdered(line -> {
            if (line == null) {
                return;
            }
            try {
                fileWriter.write((String)line);
                fileWriter.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        });
        fileWriter.close();
    }

    private String transformPomLine(String line, Map<String, String> artifactMapping) {
        String spaces;
        for (Map.Entry<String, String> mappedArtifact : artifactMapping.entrySet()) {
            if (!line.matches(".*" + mappedArtifact.getKey() + ".*")) continue;
            return line.replaceAll(mappedArtifact.getKey(), mappedArtifact.getValue());
        }
        if (this.skipVersion) {
            this.skipVersion = false;
            if (line.matches(VERSION_LINE)) {
                return null;
            }
        }
        if (line.contains(SERVLET_SPEC_JAKARTAEE8_GROUP_LINE)) {
            return this.getTabSpaces(line) + SERVLET_SPEC_JAKARTAEE9_GROUP_LINE;
        }
        if (line.contains(WEBSOCKETS_SPEC_JAKARTAEE8_GROUP_LINE)) {
            return this.getTabSpaces(line) + WEBSOCKETS_SPEC_JAKARTAEE9_GROUP_LINE;
        }
        if (line.contains(SERVLET_SPEC_JAKARTAEE8_ARTIFACT_LINE)) {
            spaces = this.getTabSpaces(line);
            this.skipVersion = true;
            return spaces + SERVLET_SPEC_JAKARTAEE9_ARTIFACT_LINE + "\n" + spaces + SERVLET_SPEC_VERSION_LINE;
        }
        if (line.contains(WEBSOCKETS_SPEC_JAKARTAEE8_ARTIFACT_LINE)) {
            spaces = this.getTabSpaces(line);
            this.skipVersion = true;
            return spaces + WEBSOCKETS_SPEC_JAKARTAEE9_ARTIFACT_LINE + "\n" + spaces + WEBSOCKETS_SPEC_VERSION_LINE;
        }
        return line;
    }

    private String getTabSpaces(String inputLine) {
        return inputLine.substring(0, inputLine.indexOf(60));
    }
}

