/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.server.HttpOpenListener;
import io.undertow.server.HttpTransferEncodingHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.server.handlers.file.CachingFileCache;
import io.undertow.server.handlers.file.FileHandler;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedStreamChannel;

public final class SimpleServer {
    public static void main(String ... args) throws IOException {
        if (args.length != 5) {
            throw new RuntimeException("you need to pass two parameters, port and folder to serve");
        }
        int port = Integer.parseInt(args[0]);
        String path = args[1];
        int writeThreads = Integer.parseInt(args[2]);
        int readThreads = Integer.parseInt(args[3]);
        int workerThreads = Integer.parseInt(args[4]);
        System.out.println("starting on port: " + port);
        System.out.println("serving path: " + path);
        Xnio xnio = Xnio.getInstance();
        OptionMap map = OptionMap.builder().set(Options.WORKER_WRITE_THREADS, writeThreads).set(Options.WORKER_READ_THREADS, readThreads).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, workerThreads).set(Options.WORKER_TASK_MAX_THREADS, 12).getMap();
        XnioWorker worker = xnio.createWorker(map);
        final HttpOpenListener openListener = new HttpOpenListener((Pool<ByteBuffer>)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 0x4000000));
        FileHandler fileHandler = new FileHandler(new File(path));
        fileHandler.setFileCache(new CachingFileCache(1024, 10480));
        openListener.setRootHandler(new HttpTransferEncodingHandler(new CanonicalPathHandler(new SimpleErrorPageHandler(fileHandler))));
        worker.createStreamServer((SocketAddress)new InetSocketAddress(port), (ChannelListener)new ChannelListener<AcceptingChannel<ConnectedStreamChannel>>(){

            public void handleEvent(AcceptingChannel<ConnectedStreamChannel> channel) {
                try {
                    ConnectedStreamChannel accept = (ConnectedStreamChannel)channel.accept();
                    if (accept == null) {
                        return;
                    }
                    openListener.handleEvent(accept);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, map).resumeAccepts();
    }
}

