/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpReadListener;
import io.undertow.server.HttpServerConnection;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.Pool;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class HttpOpenListener
implements ChannelListener<ConnectedStreamChannel> {
    private final Pool<ByteBuffer> bufferPool;
    private volatile HttpHandler rootHandler;
    private volatile int maxConcurrentRequestsPerConnection = 1;

    public HttpOpenListener(Pool<ByteBuffer> pool) {
        this.bufferPool = pool;
    }

    public void handleEvent(ConnectedStreamChannel channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", channel.getPeerAddress());
        }
        PushBackStreamChannel pushBackStreamChannel = new PushBackStreamChannel((StreamSourceChannel)channel);
        HttpServerConnection connection = new HttpServerConnection(channel, this.bufferPool, this.rootHandler, this.maxConcurrentRequestsPerConnection);
        HttpReadListener readListener = new HttpReadListener((StreamSinkChannel)channel, connection);
        pushBackStreamChannel.getReadSetter().set((ChannelListener)readListener);
        readListener.handleEvent(pushBackStreamChannel);
    }

    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    public int getMaxConcurrentRequestsPerConnection() {
        return this.maxConcurrentRequestsPerConnection;
    }

    public void setMaxConcurrentRequestsPerConnection(int maxConcurrentRequestsPerConnection) {
        if (maxConcurrentRequestsPerConnection <= 0) {
            throw UndertowMessages.MESSAGES.maximumConcurrentRequestsMustBeLargerThanZero();
        }
        this.maxConcurrentRequestsPerConnection = maxConcurrentRequestsPerConnection;
    }
}

