/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.ChannelWrapper;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.AttachmentList;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.DateUtils;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xnio.channels.StreamSinkChannel;

public class CookieHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        Map<String, Cookie> cookies = CookieHandler.parseCookies(exchange);
        exchange.putAttachment(Cookie.REQUEST_COOKIES, new CopyOnWriteMap<String, Cookie>(cookies));
        exchange.putAttachment(Cookie.RESPONSE_COOKIES, new AttachmentList<Cookie>(Cookie.class));
        exchange.addResponseWrapper(CookieChannelWrapper.INSTANCE);
        HttpHandlers.executeHandler(this.next, exchange, completionHandler);
    }

    private static Map<String, Cookie> parseCookies(HttpServerExchange exchange) {
        Deque<String> cookies = exchange.getRequestHeaders().get("Cookie");
        if (cookies == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> parsedCookies = new HashMap<String, Cookie>();
        for (String cookie : cookies) {
            CookieHandler.parseCookie(cookie, parsedCookies);
        }
        return parsedCookies;
    }

    private static void parseCookie(String cookie, Map<String, Cookie> parsedCookies) {
        int state = 0;
        String name = null;
        int start = 0;
        block6: for (int i = 0; i < cookie.length(); ++i) {
            char c = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t') {
                        start = i + 1;
                        continue block6;
                    }
                    state = 1;
                }
                case 1: {
                    if (c != '=') continue block6;
                    name = cookie.substring(start, i);
                    start = i + 1;
                    state = 2;
                    continue block6;
                }
                case 2: {
                    String value;
                    if (c == ';') {
                        value = cookie.substring(start, i);
                        parsedCookies.put(name, new Cookie(name, value));
                        state = 0;
                        start = i + 1;
                        continue block6;
                    }
                    if (c != '\"') continue block6;
                    state = 3;
                    start = i + 1;
                    continue block6;
                }
                case 3: {
                    if (c != '\"') continue block6;
                    String value = cookie.substring(start, i);
                    parsedCookies.put(name, new Cookie(name, value));
                    state = 0;
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            String value = cookie.substring(start);
            parsedCookies.put(name, new Cookie(name, value));
        }
    }

    private static void addResponseCookieToExchange(Cookie cookie, HttpServerExchange exchange) {
        if (exchange.isResponseStarted()) {
            UndertowLogger.REQUEST_LOGGER.couldNotSendSessionCookieAsResponseAlreadyStarted();
            return;
        }
        String headerName = "Set-Cookie";
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=\"");
        header.append(cookie.getValue());
        header.append("\"; ");
        if (cookie.getVersion() == 1) {
            header.append("Version=\"1\"; ");
            headerName = "Set-Cookie2";
        }
        if (cookie.getPath() != null) {
            header.append("Path=");
            header.append(cookie.getPath());
            header.append("; ");
        }
        if (cookie.getDomain() != null) {
            header.append("Domain=");
            header.append(cookie.getDomain());
            header.append("; ");
        }
        if (cookie.isDiscard()) {
            header.append("Discard; ");
        }
        if (cookie.isSecure()) {
            header.append("Secure; ");
        }
        if (cookie.isHttpOnly()) {
            header.append("HttpOnly; ");
        }
        if (cookie.getMaxAge() != null) {
            header.append("Max-Age=");
            header.append(cookie.getMaxAge());
            header.append("; ");
        }
        if (cookie.getExpires() != null) {
            header.append("Expires=");
            header.append(DateUtils.toDateString(cookie.getExpires()));
            header.append("; ");
        }
        exchange.getResponseHeaders().add(headerName, header.toString());
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public void setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
    }

    private static class CookieChannelWrapper
    implements ChannelWrapper<StreamSinkChannel> {
        public static CookieChannelWrapper INSTANCE = new CookieChannelWrapper();

        private CookieChannelWrapper() {
        }

        @Override
        public StreamSinkChannel wrap(StreamSinkChannel channel, HttpServerExchange exchange) {
            List<Cookie> cookies = exchange.getAttachmentList(Cookie.RESPONSE_COOKIES);
            for (Cookie cookie : cookies) {
                CookieHandler.addResponseCookieToExchange(cookie, exchange);
            }
            return channel;
        }
    }
}

