/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import java.util.Deque;
import java.util.Map;

public class NameVirtualHostHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final Map<String, HttpHandler> hosts = new CopyOnWriteMap<String, HttpHandler>();

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        HttpHandler handler;
        Deque<String> host = exchange.getRequestHeaders().get("Host");
        if (host != null && (handler = this.hosts.get(host.getFirst())) != null) {
            HttpHandlers.executeHandler(handler, exchange, completionHandler);
        }
        HttpHandlers.executeHandler(this.defaultHandler, exchange, completionHandler);
    }

    public HttpHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public Map<String, HttpHandler> getHosts() {
        return this.hosts;
    }

    public void setDefaultHandler(HttpHandler defaultHandler) {
        HttpHandlers.handlerNotNull(defaultHandler);
        this.defaultHandler = defaultHandler;
    }

    public synchronized void addHost(String host, HttpHandler handler) {
        HttpHandlers.handlerNotNull(handler);
        this.hosts.put(host, handler);
    }

    public synchronized void removeHost(String host) {
        this.hosts.remove(host);
    }
}

