/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class EncodingHandler
implements HttpHandler {
    private volatile HttpHandler identityHandler = ResponseCodeHandler.HANDLE_406;
    private final Map<String, Encoding> encodingMap = new CopyOnWriteMap<String, Encoding>();
    private volatile HttpHandler noEncodingHandler = ResponseCodeHandler.HANDLE_406;
    private static final String IDENTITY = "identity";

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        Deque<String> res = exchange.getRequestHeaders().get("Accept-Encoding");
        HttpHandler identityHandler = this.identityHandler;
        if (res == null || res.isEmpty()) {
            if (identityHandler != null) {
                HttpHandlers.executeHandler(identityHandler, exchange, completionHandler);
            } else {
                HttpHandlers.executeHandler(this.noEncodingHandler, exchange, completionHandler);
            }
            return;
        }
        boolean identityProhibited = false;
        ArrayList<ParsedEncoding> found = new ArrayList<ParsedEncoding>();
        ParsedEncoding current = null;
        for (String header : res) {
            int l = header.length();
            int stringStart = 0;
            block6: for (int i = 0; i < l; ++i) {
                char c = header.charAt(i);
                switch (c) {
                    case ',': {
                        if (current != null && i - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                            current.qvalue = header.substring(stringStart + 2, i);
                            if (current.encoding.equals("*") && this.handleDefault(found, current)) {
                                identityProhibited = true;
                            }
                            current = null;
                        } else if (stringStart != i) {
                            current = this.handleNewEncoding(found, header, stringStart, i);
                        }
                        stringStart = i + 1;
                        continue block6;
                    }
                    case ';': {
                        if (stringStart == i) continue block6;
                        current = this.handleNewEncoding(found, header, stringStart, i);
                        stringStart = i + 1;
                        continue block6;
                    }
                    case ' ': {
                        if (stringStart != i) {
                            if (current != null && i - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                                current.qvalue = header.substring(stringStart + 2, i);
                                if (current.encoding.equals("*") && this.handleDefault(found, current)) {
                                    identityProhibited = true;
                                }
                            } else {
                                current = this.handleNewEncoding(found, header, stringStart, i);
                            }
                        }
                        stringStart = i + 1;
                    }
                }
            }
            if (stringStart == l) continue;
            if (current != null && l - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                current.qvalue = header.substring(stringStart + 2, l);
                if (!current.encoding.equals("*") || !this.handleDefault(found, current)) continue;
                identityProhibited = true;
                continue;
            }
            current = this.handleNewEncoding(found, header, stringStart, l);
        }
        int size = found.size();
        if (size == 0) {
            if (identityProhibited || identityHandler == null) {
                HttpHandlers.executeHandler(this.noEncodingHandler, exchange, completionHandler);
                return;
            }
            HttpHandlers.executeHandler(identityHandler, exchange, completionHandler);
        } else if (size == 1) {
            HttpHandlers.executeHandler(((ParsedEncoding)found.get((int)0)).handler.handler, exchange, completionHandler);
        } else {
            ParsedEncoding max = (ParsedEncoding)found.get(0);
            for (int i = 1; i < size; ++i) {
                ParsedEncoding o = (ParsedEncoding)found.get(i);
                if (o.compareTo(max) <= 0) continue;
                max = o;
            }
            HttpHandlers.executeHandler(max.handler.handler, exchange, completionHandler);
        }
    }

    private ParsedEncoding handleNewEncoding(List<ParsedEncoding> found, String header, int stringStart, int i) {
        ParsedEncoding current = new ParsedEncoding();
        current.encoding = header.substring(stringStart, i);
        Encoding handler = this.encodingMap.get(current.encoding);
        if (handler != null) {
            current.handler = handler;
            found.add(current);
        }
        return current;
    }

    private boolean handleDefault(List<ParsedEncoding> found, ParsedEncoding current) {
        if (current.qvalue != null) {
            int length = Math.min(5, current.qvalue.length());
            boolean zero = true;
            for (int j = 0; j < length; ++j) {
                if (j == 1 || current.qvalue.charAt(j) == '0') continue;
                zero = false;
                break;
            }
            if (zero) {
                return true;
            }
            current.handler = new Encoding(this.identityHandler, 0);
            found.add(current);
        }
        return false;
    }

    public HttpHandler getIdentityHandler() {
        return this.identityHandler;
    }

    public void setIdentityHandler(HttpHandler identityHandler) {
        HttpHandlers.handlerNotNull(identityHandler);
        this.identityHandler = identityHandler;
        this.addEncodingHandler(IDENTITY, identityHandler, 0);
    }

    public synchronized void addEncodingHandler(String encoding, HttpHandler handler, int priority) {
        HttpHandlers.handlerNotNull(handler);
        this.encodingMap.put(encoding, new Encoding(handler, priority));
    }

    public synchronized void removeEncodingHandler(String encoding) {
        this.encodingMap.remove(encoding);
    }

    public HttpHandler getNoEncodingHandler() {
        return this.noEncodingHandler;
    }

    public void setNoEncodingHandler(HttpHandler noEncodingHandler) {
        HttpHandlers.handlerNotNull(noEncodingHandler);
        this.noEncodingHandler = noEncodingHandler;
    }

    private static class ParsedEncoding
    implements Comparable<ParsedEncoding> {
        String encoding;
        String qvalue;
        Encoding handler;

        private ParsedEncoding() {
        }

        @Override
        public int compareTo(ParsedEncoding other) {
            String t = this.qvalue;
            String o = other.qvalue;
            if (t == null && o == null) {
                return this.handler.compareTo(other.handler);
            }
            if (o == null) {
                return 1;
            }
            if (t == null) {
                return -1;
            }
            int tl = t.length();
            int ol = o.length();
            for (int i = 0; i < 5; ++i) {
                char oc;
                char tc;
                int res;
                if (tl == i || ol == i) {
                    return ol - tl;
                }
                if (i == 1 || (res = (tc = t.charAt(i)) - (oc = o.charAt(i))) == 0) continue;
                return res;
            }
            return 0;
        }
    }

    private static final class Encoding
    implements Comparable<Encoding> {
        private final HttpHandler handler;
        private final int priority;

        private Encoding(HttpHandler handler, int priority) {
            this.handler = handler;
            this.priority = priority;
        }

        @Override
        public int compareTo(Encoding o) {
            return this.priority - o.priority;
        }
    }
}

