/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.error;

import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.StatusCodes;
import io.undertow.util.StringWriteChannelListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xnio.channels.ChannelFactory;
import org.xnio.channels.StreamSinkChannel;

public class SimpleErrorPageHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private volatile Set<Integer> responseCodes = null;

    public SimpleErrorPageHandler(HttpHandler next) {
        this.next = next;
    }

    public SimpleErrorPageHandler() {
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange, final HttpCompletionHandler completionHandler) {
        HttpHandlers.executeHandler(this.next, exchange, new HttpCompletionHandler(){

            @Override
            public void handleComplete() {
                ChannelFactory<StreamSinkChannel> factory;
                Set codes = SimpleErrorPageHandler.this.responseCodes;
                if ((codes == null ? exchange.getResponseCode() >= 400 : codes.contains(exchange.getResponseCode())) && (factory = exchange.getResponseChannelFactory()) != null) {
                    StreamSinkChannel response = (StreamSinkChannel)factory.create();
                    String errorPage = "<html><head><title>Error</title></head><body>" + exchange.getResponseCode() + " - " + StatusCodes.getReason(exchange.getResponseCode()) + "</body></html>";
                    StringWriteChannelListener listener = new StringWriteChannelListener(errorPage){

                        @Override
                        protected void writeDone(StreamSinkChannel channel) {
                            completionHandler.handleComplete();
                        }
                    };
                    listener.setup(response);
                    return;
                }
                completionHandler.handleComplete();
            }
        });
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public void setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
    }

    public Set<Integer> getResponseCodes() {
        return Collections.unmodifiableSet(this.responseCodes);
    }

    public void setResponseCodes(Set<Integer> responseCodes) {
        this.responseCodes = new HashSet<Integer>(responseCodes);
    }

    public void setResponseCodes(Integer ... responseCodes) {
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
    }
}

