/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.file.DirectBufferCache;
import io.undertow.server.handlers.file.FileCache;
import io.undertow.util.CompletionChannelExceptionHandler;
import io.undertow.util.CompletionChannelListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.jboss.logging.Logger;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.ChannelFactory;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class CachingFileCache
implements FileCache {
    private static final int DEFAULT_MAX_CACHE_FILE_SIZE = 0x200000;
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.handlers.file");
    private static final String JDK7_NO_SUCH_FILE = "java.nio.file.NoSuchFileException";
    private final DirectBufferCache cache;
    private final long maxFileSize;

    public CachingFileCache(int sliceSize, int maxSlices, long maxFileSize) {
        this.maxFileSize = maxFileSize;
        this.cache = new DirectBufferCache(sliceSize, sliceSize * maxSlices);
    }

    public CachingFileCache(int sliceSize, int maxSlices) {
        this(sliceSize, maxSlices, 0x200000L);
    }

    @Override
    public void serveFile(HttpServerExchange exchange, final HttpCompletionHandler completionHandler, File file) {
        IoUtils.safeShutdownReads((SuspendableReadChannel)exchange.getRequestChannel());
        String method = exchange.getRequestMethod();
        if (!method.equalsIgnoreCase("GET")) {
            exchange.setResponseCode(500);
            completionHandler.handleComplete();
            return;
        }
        ChannelFactory<StreamSinkChannel> factory = exchange.getResponseChannelFactory();
        if (factory == null) {
            completionHandler.handleComplete();
            return;
        }
        DirectBufferCache.CacheEntry entry = this.cache.get(file.getAbsolutePath());
        if (entry == null) {
            exchange.getConnection().getWorker().execute((Runnable)new FileWriteLoadTask(exchange, completionHandler, factory, file));
            return;
        }
        exchange.getResponseHeaders().put("Content-Length", Long.toString(entry.size()));
        if (method.equalsIgnoreCase("HEAD")) {
            completionHandler.handleComplete();
            return;
        }
        if (!entry.isEnabled()) {
            exchange.getConnection().getWorker().execute((Runnable)new FileWriteLoadTask(exchange, completionHandler, factory, file));
            return;
        }
        StreamSinkChannel responseChannel = (StreamSinkChannel)factory.create();
        responseChannel.getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

            public void handleEvent(Channel channel) {
                completionHandler.handleComplete();
            }
        });
        Pooled<ByteBuffer>[] pooled = entry.buffers();
        ByteBuffer[] buffers = new ByteBuffer[pooled.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = ((ByteBuffer)pooled[i].getResource()).slice();
        }
        new TransferListener(responseChannel, completionHandler, buffers, true).handleEvent((StreamSinkChannel)null);
    }

    private static class TransferListener
    implements ChannelListener<StreamSinkChannel> {
        private final StreamSinkChannel responseChannel;
        private final HttpCompletionHandler completionHandler;
        private final ByteBuffer[] buffers;
        private final boolean recurse;

        public TransferListener(StreamSinkChannel responseChannel, HttpCompletionHandler completionHandler, ByteBuffer[] buffers, boolean recurse) {
            this.responseChannel = responseChannel;
            this.completionHandler = completionHandler;
            this.buffers = buffers;
            this.recurse = recurse;
        }

        public void handleEvent(StreamSinkChannel channel) {
            ByteBuffer last = this.buffers[this.buffers.length - 1];
            while (last.remaining() > 0) {
                long res;
                try {
                    res = this.responseChannel.write(this.buffers);
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)this.responseChannel);
                    this.completionHandler.handleComplete();
                    return;
                }
                if (res != 0L) continue;
                if (this.recurse) {
                    this.responseChannel.getWriteSetter().set((ChannelListener)new TransferListener(this.responseChannel, this.completionHandler, this.buffers, false));
                    this.responseChannel.resumeWrites();
                }
                return;
            }
            try {
                this.responseChannel.shutdownWrites();
                if (!this.responseChannel.flush()) {
                    this.responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new CompletionChannelListener(this.completionHandler), (ChannelExceptionHandler)new CompletionChannelExceptionHandler(this.completionHandler)));
                    this.responseChannel.resumeWrites();
                    return;
                }
            }
            catch (IOException e) {
                this.completionHandler.handleComplete();
                return;
            }
            this.completionHandler.handleComplete();
        }
    }

    private class FileWriteLoadTask
    implements Runnable {
        private final HttpCompletionHandler completionHandler;
        private final File file;
        private final HttpServerExchange exchange;
        private final ChannelFactory<StreamSinkChannel> factory;

        public FileWriteLoadTask(HttpServerExchange exchange, HttpCompletionHandler completionHandler, ChannelFactory<StreamSinkChannel> factory, File file) {
            this.completionHandler = completionHandler;
            this.factory = factory;
            this.file = file;
            this.exchange = exchange;
        }

        @Override
        public void run() {
            long length;
            FileChannel fileChannel;
            String method = this.exchange.getRequestMethod();
            try {
                fileChannel = this.exchange.getConnection().getWorker().getXnio().openFile(this.file, FileAccess.READ_ONLY);
                length = fileChannel.size();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException || CachingFileCache.JDK7_NO_SUCH_FILE.equals(e.getClass().getName())) {
                    this.exchange.setResponseCode(404);
                } else {
                    this.exchange.setResponseCode(500);
                }
                this.completionHandler.handleComplete();
                return;
            }
            this.exchange.getResponseHeaders().put("Content-Length", Long.toString(length));
            if (method.equalsIgnoreCase("HEAD")) {
                this.completionHandler.handleComplete();
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                this.exchange.setResponseCode(500);
                this.completionHandler.handleComplete();
                return;
            }
            StreamSinkChannel channel = (StreamSinkChannel)this.factory.create();
            channel.getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

                public void handleEvent(Channel channel) {
                    FileWriteLoadTask.this.completionHandler.handleComplete();
                }
            });
            DirectBufferCache.CacheEntry entry = null;
            String path = this.file.getAbsolutePath();
            if (length < CachingFileCache.this.maxFileSize) {
                entry = CachingFileCache.this.cache.add(path, (int)length);
            }
            if (entry == null) {
                this.transfer(channel, fileChannel, length);
                return;
            }
            Pooled<ByteBuffer>[] pooled = entry.buffers();
            ByteBuffer[] buffers = new ByteBuffer[pooled.length];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = (ByteBuffer)pooled[i].getResource();
            }
            long remaining = length;
            while (remaining > 0L) {
                try {
                    long res = fileChannel.read(buffers);
                    if (res <= 0L) continue;
                    remaining -= res;
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)fileChannel);
                    CachingFileCache.this.cache.remove(path);
                    this.exchange.setResponseCode(500);
                    this.completionHandler.handleComplete();
                    return;
                }
            }
            ByteBuffer lastBuffer = buffers[buffers.length - 1];
            lastBuffer.limit(lastBuffer.position());
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i].position(0);
                buffers[i] = buffers[i].slice();
            }
            entry.enable();
            lastBuffer = buffers[buffers.length - 1];
            new TransferListener(channel, this.completionHandler, buffers, true).handleEvent((StreamSinkChannel)null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transfer(StreamSinkChannel channel, FileChannel fileChannel, long length) {
            try {
                log.tracef("Serving file %s (blocking)", (Object)fileChannel);
                Channels.transferBlocking((StreamSinkChannel)channel, (FileChannel)fileChannel, (long)0L, (long)length);
                log.tracef("Finished serving %s, shutting down (blocking)", (Object)fileChannel);
                channel.shutdownWrites();
                log.tracef("Finished serving %s, flushing (blocking)", (Object)fileChannel);
                Channels.flushBlocking((SuspendableWriteChannel)channel);
                log.tracef("Finished serving %s (complete)", (Object)fileChannel);
                this.completionHandler.handleComplete();
            }
            catch (IOException ignored) {
                log.tracef("Failed to serve %s: %s", (Object)fileChannel, (Object)ignored);
                IoUtils.safeClose((Closeable)fileChannel);
                this.completionHandler.handleComplete();
            }
            finally {
                IoUtils.safeClose((Closeable)fileChannel);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }
}

