/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.file.FileCache;
import io.undertow.util.CompletionChannelExceptionHandler;
import io.undertow.util.CompletionChannelListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.channels.ChannelFactory;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableReadChannel;

public class InLineFileCache
implements FileCache {
    public static final FileCache INSTANCE = new InLineFileCache();

    @Override
    public void serveFile(HttpServerExchange exchange, final HttpCompletionHandler completionHandler, File file) {
        long res;
        long length;
        FileChannel fileChannel;
        IoUtils.safeShutdownReads((SuspendableReadChannel)exchange.getRequestChannel());
        String method = exchange.getRequestMethod();
        try {
            try {
                fileChannel = exchange.getConnection().getWorker().getXnio().openFile(file, FileAccess.READ_ONLY);
            }
            catch (FileNotFoundException e) {
                exchange.setResponseCode(404);
                completionHandler.handleComplete();
                return;
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_LOGGER.exceptionReadingFile(file, e);
            exchange.setResponseCode(500);
            completionHandler.handleComplete();
            return;
        }
        exchange.getResponseHeaders().put("Content-Length", Long.toString(length));
        if (method.equalsIgnoreCase("HEAD")) {
            completionHandler.handleComplete();
            return;
        }
        if (!method.equalsIgnoreCase("GET")) {
            exchange.setResponseCode(500);
            completionHandler.handleComplete();
            return;
        }
        ChannelFactory<StreamSinkChannel> factory = exchange.getResponseChannelFactory();
        if (factory == null) {
            IoUtils.safeClose((Closeable)fileChannel);
            completionHandler.handleComplete();
            return;
        }
        StreamSinkChannel responseChannel = (StreamSinkChannel)factory.create();
        responseChannel.getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

            public void handleEvent(Channel channel) {
                IoUtils.safeClose((Closeable)fileChannel);
                completionHandler.handleComplete();
            }
        });
        long pos = 0L;
        for (length = fileChannel.size(); length > 0L; length -= res) {
            try {
                res = responseChannel.transferFrom(fileChannel, pos, length);
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)fileChannel);
                IoUtils.safeClose((Closeable)responseChannel);
                completionHandler.handleComplete();
                return;
            }
            if (res == 0L) {
                responseChannel.getWriteSetter().set((ChannelListener)new TransferListener(length, pos, responseChannel, fileChannel, completionHandler));
                responseChannel.resumeWrites();
                return;
            }
            pos += res;
        }
        IoUtils.safeClose((Closeable)fileChannel);
        try {
            responseChannel.shutdownWrites();
            if (!responseChannel.flush()) {
                responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new CompletionChannelListener(completionHandler), (ChannelExceptionHandler)new CompletionChannelExceptionHandler(completionHandler)));
                responseChannel.resumeWrites();
                return;
            }
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)fileChannel);
            IoUtils.safeClose((Closeable)responseChannel);
            completionHandler.handleComplete();
            return;
        }
    }

    private static class TransferListener
    implements ChannelListener<StreamSinkChannel> {
        private long length;
        private long pos;
        private final StreamSinkChannel responseChannel;
        private final FileChannel fileChannel;
        private final HttpCompletionHandler completionHandler;

        public TransferListener(long length, long pos, StreamSinkChannel responseChannel, FileChannel fileChannel, HttpCompletionHandler completionHandler) {
            this.length = length;
            this.pos = pos;
            this.responseChannel = responseChannel;
            this.fileChannel = fileChannel;
            this.completionHandler = completionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(StreamSinkChannel channel) {
            long length;
            long pos = this.pos;
            try {
                long res;
                for (length = this.length; length > 0L; length -= res) {
                    try {
                        res = this.responseChannel.transferFrom(this.fileChannel, pos, length);
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)this.fileChannel);
                        this.responseChannel.suspendWrites();
                        IoUtils.safeClose((Closeable)this.responseChannel);
                        this.completionHandler.handleComplete();
                        this.length = length;
                        this.pos = pos;
                        return;
                    }
                    if (res == 0L) {
                        return;
                    }
                    pos += res;
                }
                IoUtils.safeClose((Closeable)this.fileChannel);
                try {
                    this.responseChannel.shutdownWrites();
                    if (!this.responseChannel.flush()) {
                        this.responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new CompletionChannelListener(this.completionHandler), (ChannelExceptionHandler)new CompletionChannelExceptionHandler(this.completionHandler)));
                        this.responseChannel.resumeWrites();
                        return;
                    }
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)this.fileChannel);
                    this.responseChannel.suspendWrites();
                    IoUtils.safeClose((Closeable)this.responseChannel);
                    this.completionHandler.handleComplete();
                    return;
                }
            }
            finally {
                this.length = length;
                this.pos = pos;
            }
        }
    }
}

