/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.file.FileCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.channels.ChannelFactory;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class PermanentFileCache
implements FileCache {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.handlers.file");
    private final ConcurrentMap<String, FileChannel> channels = new ConcurrentHashMap<String, FileChannel>();

    @Override
    public void serveFile(HttpServerExchange exchange, HttpCompletionHandler completionHandler, File file) {
        long length;
        FileChannel fileChannel;
        IoUtils.safeShutdownReads((SuspendableReadChannel)exchange.getRequestChannel());
        String method = exchange.getRequestMethod();
        try {
            fileChannel = (FileChannel)this.channels.get(file.getPath());
            if (fileChannel == null) {
                try {
                    fileChannel = exchange.getConnection().getWorker().getXnio().openFile(file, FileAccess.READ_ONLY);
                }
                catch (FileNotFoundException e) {
                    exchange.setResponseCode(404);
                    completionHandler.handleComplete();
                    return;
                }
                FileChannel appearing = this.channels.putIfAbsent(file.getPath(), fileChannel);
                if (appearing != null) {
                    IoUtils.safeClose((Closeable)fileChannel);
                    fileChannel = appearing;
                }
            }
            length = fileChannel.size();
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_LOGGER.exceptionReadingFile(file, e);
            exchange.setResponseCode(500);
            completionHandler.handleComplete();
            return;
        }
        exchange.getResponseHeaders().put("Content-Length", Long.toString(length));
        if (method.equalsIgnoreCase("HEAD")) {
            completionHandler.handleComplete();
            return;
        }
        if (!method.equalsIgnoreCase("GET")) {
            exchange.setResponseCode(500);
            completionHandler.handleComplete();
            return;
        }
        ChannelFactory<StreamSinkChannel> factory = exchange.getResponseChannelFactory();
        if (factory == null) {
            completionHandler.handleComplete();
            return;
        }
        StreamSinkChannel response = (StreamSinkChannel)factory.create();
        response.getWorker().execute((Runnable)new FileWriteTask(completionHandler, response, fileChannel, length));
    }

    private static class FileWriteTask
    implements Runnable {
        private final HttpCompletionHandler completionHandler;
        private final StreamSinkChannel channel;
        private final FileChannel fileChannel;
        private final long length;

        public FileWriteTask(HttpCompletionHandler completionHandler, StreamSinkChannel channel, FileChannel fileChannel, long length) {
            this.completionHandler = completionHandler;
            this.channel = channel;
            this.fileChannel = fileChannel;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                log.tracef("Serving file %s (blocking)", (Object)this.fileChannel);
                Channels.transferBlocking((StreamSinkChannel)this.channel, (FileChannel)this.fileChannel, (long)0L, (long)this.length);
                log.tracef("Finished serving %s, shutting down (blocking)", (Object)this.fileChannel);
                this.channel.shutdownWrites();
                log.tracef("Finished serving %s, flushing (blocking)", (Object)this.fileChannel);
                Channels.flushBlocking((SuspendableWriteChannel)this.channel);
                log.tracef("Finished serving %s (complete)", (Object)this.fileChannel);
                this.completionHandler.handleComplete();
            }
            catch (IOException ignored) {
                log.tracef("Failed to serve %s: %s", (Object)this.fileChannel, (Object)ignored);
                this.completionHandler.handleComplete();
            }
            finally {
                IoUtils.safeClose((Closeable)this.channel);
            }
        }
    }
}

