/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import java.io.Closeable;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

public class EagerFormParsingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    @Override
    public void handleRequest(final HttpServerExchange exchange, final HttpCompletionHandler completionHandler) {
        FormDataParser parser = exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
        if (parser == null) {
            HttpHandlers.executeHandler(this.next, exchange, completionHandler);
            return;
        }
        IoFuture<FormData> future = parser.parse();
        future.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<FormData, Object>(){

            public void notify(IoFuture<? extends FormData> ioFuture, Object attachment) {
                if (ioFuture.getStatus() == IoFuture.Status.DONE) {
                    HttpHandlers.executeHandler(EagerFormParsingHandler.this.next, exchange, completionHandler);
                } else if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    UndertowLogger.REQUEST_LOGGER.ioExceptionReadingFromChannel(ioFuture.getException());
                    IoUtils.safeClose((Closeable)exchange.getRequestChannel());
                    completionHandler.handleComplete();
                }
            }
        }, null);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public void setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
    }
}

