/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.session.Session;

public class SessionCookieConfig {
    public static final String ATTACHMENT_KEY = "io.undertow.session.SessionCookie";
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    private final String cookieName;
    private final String path;
    private final String domain;
    private final boolean discard;
    private final boolean secure;

    public SessionCookieConfig(String cookieName, String path, String domain, boolean discard, boolean secure) {
        this.cookieName = cookieName;
        this.path = path;
        this.domain = domain;
        this.discard = discard;
        this.secure = secure;
    }

    public void setSessionCookie(HttpServerExchange exchange, Session session) {
        Cookie cookie = new Cookie(this.cookieName, session.getId()).setPath(this.path).setDomain(this.domain).setDiscard(this.discard).setSecure(this.secure);
        Cookie.addResponseCookie(exchange, cookie);
    }

    public void clearCookie(HttpServerExchange exchange, Session session) {
        Cookie cookie = new Cookie(this.cookieName, session.getId()).setPath(this.path).setDomain(this.domain).setDiscard(this.discard).setSecure(this.secure).setMaxAge(0);
        Cookie.addResponseCookie(exchange, cookie);
    }
}

