/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private static final Locale LOCALE_US = Locale.US;
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static final String RFC1036_PATTERN = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String ASCITIME_PATTERN = "EEE MMM d HH:mm:ss yyyyy";
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";

    public static String toDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(RFC1123_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        return dateFormat.format(date);
    }

    public static Date parseDate(String date) {
        ParsePosition pp = new ParsePosition(0);
        SimpleDateFormat dateFormat = new SimpleDateFormat(RFC1123_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        Date val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(RFC1036_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(ASCITIME_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(OLD_COOKIE_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(date, pp);
        if (val != null && pp.getIndex() == date.length()) {
            return val;
        }
        return null;
    }
}

