/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.nio.Log;
import org.xnio.nio.WorkerThread;

final class NioHandle<C extends Channel>
implements Runnable {
    private final SelectionKey selectionKey;
    private final WorkerThread workerThread;
    private final ChannelListener.SimpleSetter<C> handlerSetter;
    private final C channel;
    private volatile int scheduled;
    private static final AtomicIntegerFieldUpdater<NioHandle> scheduledUpdater = AtomicIntegerFieldUpdater.newUpdater(NioHandle.class, "scheduled");

    NioHandle(SelectionKey selectionKey, WorkerThread workerThread, ChannelListener.SimpleSetter<C> handlerSetter, C channel) {
        this.selectionKey = selectionKey;
        this.workerThread = workerThread;
        this.handlerSetter = handlerSetter;
        this.channel = channel;
    }

    WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    ChannelListener.SimpleSetter<C> getHandlerSetter() {
        return this.handlerSetter;
    }

    void cancelKey() {
        this.workerThread.cancelKey(this.selectionKey);
    }

    void resume(int op) {
        this.workerThread.setOps(this.selectionKey, op);
    }

    void suspend() {
        this.workerThread.setOps(this.selectionKey, 0);
    }

    boolean isResumed(int op) {
        return (this.workerThread.getOps(this.selectionKey) & op) == op;
    }

    C getChannel() {
        return this.channel;
    }

    @Override
    public void run() {
        this.scheduled = 0;
        ChannelListener listener = this.handlerSetter.get();
        if (listener == null) {
            Log.log.tracef("Null listener; suspending %s to prevent runaway", (Object)this);
            this.suspend();
        } else if (this.workerThread.getOps(this.selectionKey) != 0) {
            ChannelListeners.invokeChannelListener(this.channel, (ChannelListener)listener);
        }
    }

    void execute() {
        if (scheduledUpdater.compareAndSet(this, 0, 1)) {
            this.workerThread.execute(this);
        }
    }
}

