/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import java.io.File;
import java.io.IOException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.xnio.IoFuture;

@MessageLogger(projectCode="UNDERTOW")
public interface UndertowLogger
extends BasicLogger {
    public static final UndertowLogger ROOT_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)UndertowLogger.class.getPackage().getName());
    public static final UndertowLogger REQUEST_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)(UndertowLogger.class.getPackage().getName() + ".request"));

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5001, value="An exception occurred processing the request")
    public void exceptionProcessingRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5002, value="An exception occurred getting the session")
    public void getSessionFailed(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5003, value="Unexpected state in session callback %s")
    public void unexpectedStatusGettingSession(IoFuture.Status var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5004, value="Could not send session cookie as response has already started")
    public void couldNotSendSessionCookieAsResponseAlreadyStarted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5005, value="Could not invalidate session cookie as response has already started")
    public void couldNotInvalidateSessionCookieAsResponseAlreadyStarted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5006, value="Could not find session cookie config in the request, session will not be persistent across requests")
    public void couldNotFindSessionCookieConfig();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5007, value="Configured error page %s was not found")
    public void errorPageDoesNotExist(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5008, value="Exception reading error page %s")
    public void errorLoadingErrorPage(@Cause IOException var1, File var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5009, value="Exception reading file %s: %s")
    public void exceptionReadingFile(File var1, IOException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5010, value="IOException writing to channel")
    public void ioExceptionWritingToChannel(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5011, value="IOException writing to channel")
    public void ioExceptionClosingChannel(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5012, value="File was requested outside the handlers base directory. Installing a canonical path handler in front of the file handler will prevent this")
    public void fileHandlerWithoutCanonicalPathHandler();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5013, value="IOException reading from channel")
    public void ioExceptionReadingFromChannel(@Cause IOException var1);
}

